/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.util.Utils;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import java.io.Serializable;
import java.util.HashMap;

public class Timespan
implements Serializable {
    private static final long serialVersionUID = -6991526817985173927L;
    static final HashMap<String, Integer> parseValues = new HashMap();
    private final long millis;
    static final Pair<String, Integer>[] simpleValues;

    static {
        parseValues.put("tick", 50);
        parseValues.put("second", 1000);
        parseValues.put("minute", 60000);
        parseValues.put("hour", 3600000);
        parseValues.put("day", 86400000);
        simpleValues = new Pair[]{new Pair<String, Integer>("day", 86400000), new Pair<String, Integer>("hour", 3600000), new Pair<String, Integer>("minute", 60000), new Pair<String, Integer>("second", 1000)};
    }

    public static final Timespan parse(String s) {
        if (s.isEmpty()) {
            return null;
        }
        int t = 0;
        boolean minecraftTime = false;
        boolean isMinecraftTimeSet = false;
        if (s.matches("^\\d+:\\d\\d$")) {
            String[] ss = s.split(":");
            int[] times = new int[]{60000, 1000};
            int i = 0;
            while (i < ss.length) {
                t += times[i] * Skript.parseInt(ss[i]);
                ++i;
            }
        } else {
            String[] subs = s.toLowerCase().split("\\s+");
            int i = 0;
            while (i < subs.length) {
                String sub = subs[i];
                if (sub.equals("and")) {
                    if (i == 0 || i == subs.length - 1) {
                        return null;
                    }
                } else {
                    float amount = 1.0f;
                    if (sub.equalsIgnoreCase("a") || sub.equalsIgnoreCase("an")) {
                        if (i == subs.length - 1) {
                            return null;
                        }
                        amount = 1.0f;
                        sub = subs[++i];
                    } else if (sub.matches("^\\d+(.\\d+)?$")) {
                        if (i == subs.length - 1) {
                            return null;
                        }
                        amount = Float.parseFloat(sub);
                        sub = subs[++i];
                    }
                    if (sub.equals("real") || sub.equals("rl") || sub.equals("irl")) {
                        if (i == subs.length - 1 || isMinecraftTimeSet && minecraftTime) {
                            return null;
                        }
                        sub = subs[++i];
                    } else if (sub.equals("mc") || sub.equals("minecraft")) {
                        if (i == subs.length - 1 || isMinecraftTimeSet && !minecraftTime) {
                            return null;
                        }
                        minecraftTime = true;
                        sub = subs[++i];
                    }
                    if (minecraftTime) {
                        amount /= 72.0f;
                    }
                    if (sub.endsWith(",")) {
                        sub = sub.substring(0, sub.length() - 1);
                    }
                    Pair<String, Boolean> p = Utils.getPlural(sub);
                    sub = (String)p.first;
                    if (!parseValues.containsKey(sub)) {
                        return null;
                    }
                    if (sub.equals("tick") && minecraftTime) {
                        amount *= 72.0f;
                    }
                    t += Math.round(amount * (float)parseValues.get(sub).intValue());
                    isMinecraftTimeSet = true;
                }
                ++i;
            }
        }
        return new Timespan(t);
    }

    public Timespan(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("millis must be >= 0");
        }
        this.millis = millis;
    }

    public static Timespan fromTicks(int ticks) {
        return new Timespan(ticks * 50);
    }

    public long getMilliSeconds() {
        return this.millis;
    }

    public int getTicks() {
        return Math.round((float)this.millis / 50.0f);
    }

    public String toString() {
        return Timespan.toString(this.millis);
    }

    public static String toString(long millis) {
        int i = 0;
        while (i < simpleValues.length - 1) {
            if (millis >= (long)((Integer)Timespan.simpleValues[i].second).intValue()) {
                if (millis % (long)((Integer)Timespan.simpleValues[i].second).intValue() != 0L) {
                    return String.valueOf(Timespan.toString(Math.floor(1.0 * (double)millis / (double)((Integer)Timespan.simpleValues[i].second).intValue()), simpleValues[i])) + " and " + Timespan.toString(1.0 * (double)(millis % (long)((Integer)Timespan.simpleValues[i].second).intValue()) / (double)((Integer)Timespan.simpleValues[i + 1].second).intValue(), simpleValues[i + 1]);
                }
                return Timespan.toString(1.0 * (double)millis / (double)((Integer)Timespan.simpleValues[i].second).intValue(), simpleValues[i]);
            }
            ++i;
        }
        return Timespan.toString(1.0 * (double)millis / (double)((Integer)Timespan.simpleValues[Timespan.simpleValues.length - 1].second).intValue(), simpleValues[simpleValues.length - 1]);
    }

    private static String toString(double amount, Pair<String, Integer> p) {
        return String.valueOf(StringUtils.toString(amount, 2)) + " " + Utils.toPlural((String)p.first, amount != 1.0);
    }
}

