/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.util.Utils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.command.CommandSender;

public class CommandHelp {
    private String command;
    private final String description;
    private final String argsColor;
    private final Map<String, Object> arguments = new LinkedHashMap<String, Object>();
    private Object wildcardArg = null;

    public CommandHelp(String command, String description, String argsColor) {
        this.command = command;
        this.description = description;
        this.argsColor = argsColor;
    }

    public CommandHelp add(String argument, String description) {
        if (argument.startsWith("<") && argument.endsWith(">")) {
            argument = "<gray><<" + this.argsColor + ">" + argument.substring(1, argument.length() - 1) + "<gray>>";
            this.wildcardArg = description;
        }
        this.arguments.put(argument, description);
        return this;
    }

    public CommandHelp add(CommandHelp help) {
        this.arguments.put(help.command, help);
        help.command = String.valueOf(this.command) + " <" + this.argsColor + ">" + help.command;
        return this;
    }

    private static final void message(CommandSender recipient, String message) {
        recipient.sendMessage(Utils.prepareMessage(message));
    }

    public boolean test(CommandSender sender, String[] args) {
        return this.test(sender, args, 0);
    }

    private boolean test(CommandSender sender, String[] args, int index) {
        if (index >= args.length) {
            this.showHelp(sender);
            return false;
        }
        Object help = this.arguments.get(args[index].toLowerCase());
        if (help == null && this.wildcardArg == null) {
            this.showHelp(sender, "Invalid argument <gray>'<" + this.argsColor + ">" + args[index] + "<gray>'<reset>. Correct usage:");
            return false;
        }
        if (help instanceof CommandHelp) {
            return ((CommandHelp)help).test(sender, args, index + 1);
        }
        return true;
    }

    public void showHelp(CommandSender sender) {
        this.showHelp(sender, "Usage:");
    }

    private void showHelp(CommandSender sender, String pre) {
        CommandHelp.message(sender, String.valueOf(pre) + " " + this.command + " <" + this.argsColor + ">...");
        for (Map.Entry<String, Object> e : this.arguments.entrySet()) {
            CommandHelp.message(sender, "  <" + this.argsColor + ">" + e.getKey() + " <gray>-<reset> " + e.getValue());
        }
    }

    public String toString() {
        return this.description;
    }
}

