/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.util.ContanerExpression;
import ch.njol.skript.util.Container;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.event.Event;

public class Loop
extends TriggerSection {
    private static final long serialVersionUID = -6026515058664939972L;
    private final Expression<?> expr;
    private transient Map<Event, Object> current = new WeakHashMap<Event, Object>();
    private transient Map<Event, Iterator<?>> currentIter = new WeakHashMap();
    private TriggerItem actualNext;

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.current = new WeakHashMap<Event, Object>();
        this.currentIter = new WeakHashMap();
    }

    public <T> Loop(Expression<?> expr, SectionNode node) {
        assert (expr != null);
        assert (node != null);
        if (Container.class.isAssignableFrom(expr.getReturnType())) {
            Container.ContainerType type = expr.getReturnType().getAnnotation(Container.ContainerType.class);
            if (type == null) {
                throw new SkriptAPIException(String.valueOf(expr.getReturnType().getName()) + " implements Container but is missing the required @ContainerType annotation");
            }
            this.expr = new ContanerExpression(expr, type.value());
        } else {
            this.expr = expr;
        }
        ScriptLoader.currentLoops.add(this);
        this.setTriggerItems(ScriptLoader.loadItems(node));
        ScriptLoader.currentLoops.remove(ScriptLoader.currentLoops.size() - 1);
        super.setNext(this);
    }

    @Override
    protected TriggerItem walk(Event e) {
        Iterator<?> iter = this.currentIter.get(e);
        if (iter == null) {
            Iterator<Object> iterator = iter = this.expr instanceof Variable ? ((Variable)this.expr).variablesIterator(e) : this.expr.iterator(e);
            if (iter != null) {
                if (iter.hasNext()) {
                    this.currentIter.put(e, iter);
                } else {
                    iter = null;
                }
            }
        }
        if (iter == null || !iter.hasNext()) {
            if (iter != null) {
                this.currentIter.remove(e);
            } else {
                this.debug(e, false);
            }
            return this.actualNext;
        }
        this.current.put(e, iter.next());
        return this.walk(e, true);
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "loop " + this.expr.toString(e, debug);
    }

    public Object getCurrent(Event e) {
        return this.current.get(e);
    }

    public Expression<?> getLoopedExpression() {
        return this.expr;
    }

    @Override
    public void setNext(TriggerItem next) {
        this.actualNext = next;
    }

    public TriggerItem getActualNext() {
        return this.actualNext;
    }
}

