/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.hooks;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.hooks.Economy;
import ch.njol.skript.lang.ParseContext;

public class Money {
    private final double amount;

    static {
        if (Economy.getEconomy() != null) {
            Skript.registerClass(new ClassInfo<Money>(Money.class, "money", "money").user("money").parser(new Parser<Money>(){

                @Override
                public Money parse(String s, ParseContext context) {
                    return Money.parse(s);
                }

                @Override
                public String toString(Money m) {
                    return m.toString();
                }

                @Override
                public String toVariableNameString(Money o) {
                    return "money:" + o.amount;
                }

                @Override
                public String getVariableNamePattern() {
                    return "money:-?\\d+(\\.\\d+)?";
                }
            }));
        }
    }

    public Money(double amount) {
        this.amount = amount;
    }

    public double getAmount() {
        return this.amount;
    }

    public static final Money parse(String s) {
        if (Economy.getEconomy() == null) {
            Skript.error("No economy plugin detected");
            return null;
        }
        if (!Economy.plural.isEmpty() && s.toLowerCase().endsWith(Economy.pluralLower)) {
            try {
                double d = Double.parseDouble(s.substring(0, s.length() - Economy.plural.length()).trim());
                return new Money(d);
            }
            catch (NumberFormatException d) {
                // empty catch block
            }
        }
        if (!Economy.singular.isEmpty() && s.toLowerCase().endsWith(Economy.singularLower)) {
            try {
                double d = Double.parseDouble(s.substring(0, s.length() - Economy.singular.length()).trim());
                return new Money(d);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            return new Money(Double.parseDouble(s));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String toString() {
        return Economy.getEconomy().format(this.amount);
    }
}

