/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ExprXOfItem
extends PropertyExpression<ItemStack, ItemStack> {
    private static final long serialVersionUID = 5709306242713886383L;
    private Expression<Number> amount;

    static {
        Skript.registerExpression(ExprXOfItem.class, ItemStack.class, Skript.ExpressionType.PATTERN_MATCHES_EVERYTHING, "%number% of %itemstacks%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[1]);
        this.amount = exprs[0];
        return !(this.amount instanceof Literal) || !(this.getExpr() instanceof Literal);
    }

    @Override
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    protected ItemStack[] get(final Event e, ItemStack[] source) {
        return this.get(source, new Converter<ItemStack, ItemStack>(){

            @Override
            public ItemStack convert(ItemStack is) {
                Number a = (Number)ExprXOfItem.this.amount.getSingle(e);
                if (a == null) {
                    return null;
                }
                is.setAmount(a.intValue());
                return is;
            }
        });
    }

    @Override
    public String toString(Event e, boolean debug) {
        return this.amount + " of " + this.getExpr().toString(e, debug);
    }
}

