/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.util.Utils;
import org.bukkit.event.Event;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class ExprMessage
extends SimpleExpression<String> {
    private static final long serialVersionUID = 691567046005405494L;
    private MessageType type;

    static {
        Skript.registerExpression(ExprMessage.class, String.class, Skript.ExpressionType.SIMPLE, MessageType.patterns);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        this.type = MessageType.values()[matchedPattern];
        if (this.type == MessageType.CHAT) {
            if (!Utils.contains(ScriptLoader.currentEvents, Skript.isRunningBukkit1_3() ? AsyncPlayerChatEvent.class : PlayerChatEvent.class)) {
                Skript.error("The message can only be used in a chat event", ErrorQuality.SEMANTIC_ERROR);
                return false;
            }
        } else if (!Utils.contains(ScriptLoader.currentEvents, this.type.event)) {
            Skript.error("The " + this.type.name + " message can only be used in a " + this.type.name + " event", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    protected String[] get(Event e) {
        return new String[]{this.type.get(e)};
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return Skript.array(String.class);
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        this.type.set(e, Utils.replaceChatStyles((String)delta));
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public boolean getAnd() {
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the " + this.type.name + " message";
    }

    private static enum MessageType {
        CHAT("chat", "[chat( |-)]message", null){

            @Override
            String get(Event e) {
                if (Skript.isRunningBukkit1_3()) {
                    return ((AsyncPlayerChatEvent)e).getMessage();
                }
                return ((PlayerChatEvent)e).getMessage();
            }

            @Override
            void set(Event e, String message) {
                if (Skript.isRunningBukkit1_3()) {
                    ((AsyncPlayerChatEvent)e).setMessage(message);
                } else {
                    ((PlayerChatEvent)e).setMessage(message);
                }
            }
        }
        ,
        JOIN("join", "(join|log[ ]in)( |-)message", PlayerJoinEvent.class){

            @Override
            String get(Event e) {
                return ((PlayerJoinEvent)e).getJoinMessage();
            }

            @Override
            void set(Event e, String message) {
                ((PlayerJoinEvent)e).setJoinMessage(message);
            }
        }
        ,
        QUIT("quit", "(quit|leave|log[ ]out)( |-)message", PlayerQuitEvent.class){

            @Override
            String get(Event e) {
                return ((PlayerQuitEvent)e).getQuitMessage();
            }

            @Override
            void set(Event e, String message) {
                ((PlayerQuitEvent)e).setQuitMessage(message);
            }
        }
        ,
        DEATH("death", "death( |-)message", PlayerDeathEvent.class){

            @Override
            String get(Event e) {
                return ((PlayerDeathEvent)e).getDeathMessage();
            }

            @Override
            void set(Event e, String message) {
                ((PlayerDeathEvent)e).setDeathMessage(message);
            }
        };

        private final String name;
        private final String pattern;
        private final Class<? extends Event> event;
        static String[] patterns;

        static {
            patterns = new String[MessageType.values().length];
            int i = 0;
            while (i < patterns.length) {
                MessageType.patterns[i] = MessageType.values()[i].pattern;
                ++i;
            }
        }

        private MessageType(String name, String pattern, Class<? extends Event> event) {
            this.name = name;
            this.pattern = "[the] " + pattern;
            this.event = event;
        }

        abstract String get(Event var1);

        abstract void set(Event var1, String var2);
    }
}

