/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.SerializableConverter;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Loop;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.util.ConvertedExpression;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.event.Event;

public class ExprLoopValue
extends SimpleExpression<Object> {
    private static final long serialVersionUID = -6116372561839231268L;
    private String name;
    private Loop loop;
    boolean isVariableLoop = false;
    boolean isIndex = false;

    static {
        Skript.registerExpression(ExprLoopValue.class, Object.class, Skript.ExpressionType.SIMPLE, "[the] loop-<.+>");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, int isDelayed, SkriptParser.ParseResult parser) {
        Class<?> c;
        this.name = parser.expr;
        String s = parser.regexes.get(0).group();
        int i = -1;
        Matcher m = Pattern.compile("^(.+)-(\\d+)$").matcher(s);
        if (m.matches()) {
            s = m.group(1);
            i = Skript.parseInt(m.group(2));
        }
        if ((c = Skript.getClassByName(s)) == null) {
            c = Skript.getClassFromUserInput(s);
        }
        int j = 1;
        for (Loop l : ScriptLoader.currentLoops) {
            if ((c == null || !c.isAssignableFrom(l.getLoopedExpression().getReturnType())) && !l.getLoopedExpression().isLoopOf(s)) continue;
            if (j < i) {
                ++j;
                continue;
            }
            if (this.loop != null) {
                Skript.error("there are multiple loops that match 'loop-" + s + "'", ErrorQuality.SEMANTIC_ERROR);
                return false;
            }
            this.loop = l;
            if (j == i) break;
        }
        if (this.loop == null) {
            Skript.error("there's no loop that matches 'loop-" + s + "'", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        if (this.loop.getLoopedExpression() instanceof Variable) {
            this.isVariableLoop = true;
            if (((Variable)this.loop.getLoopedExpression()).isIndexLoop(s)) {
                this.isIndex = true;
            }
        }
        return true;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    protected <R> ConvertedExpression<Object, ? extends R> getConvertedExpr(final Class<R> to) {
        if (this.isVariableLoop && !this.isIndex) {
            return new ConvertedExpression<Object, R>(this, to, new SerializableConverter<Object, R>(){
                private static final long serialVersionUID = 7703898357092613043L;

                @Override
                public R convert(Object o) {
                    return Skript.convert(o, to);
                }
            });
        }
        return super.getConvertedExpr(to);
    }

    @Override
    public Class<? extends Object> getReturnType() {
        if (this.isIndex) {
            return String.class;
        }
        return this.loop.getLoopedExpression().getReturnType();
    }

    @Override
    protected Object[] get(Event e) {
        if (this.isVariableLoop) {
            Map.Entry current = (Map.Entry)this.loop.getCurrent(e);
            if (this.isIndex) {
                return new String[]{(String)current.getKey()};
            }
            Object[] one = (Object[])Array.newInstance(this.getReturnType(), 1);
            one[0] = current.getValue();
            return one;
        }
        Object[] one = (Object[])Array.newInstance(this.getReturnType(), 1);
        one[0] = this.loop.getCurrent(e);
        return one;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e == null) {
            return this.name;
        }
        if (this.isVariableLoop) {
            Map.Entry current = (Map.Entry)this.loop.getCurrent(e);
            return this.isIndex ? "\"" + (String)current.getKey() + "\"" : Skript.getDebugMessage(current.getValue());
        }
        return Skript.getDebugMessage(this.loop.getCurrent(e));
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

