/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Checker;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.painting.PaintingBreakEvent;
import org.bukkit.event.painting.PaintingEvent;
import org.bukkit.event.painting.PaintingPlaceEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class EvtBlock
extends SkriptEvent {
    private static final long serialVersionUID = 1975641867786762510L;
    private Literal<ItemType> types;
    private boolean mine = false;

    static {
        Skript.registerEvent(EvtBlock.class, Skript.array(BlockBreakEvent.class, PaintingBreakEvent.class, PlayerBucketFillEvent.class), "(break[ing]|min(e|ing)) [[of] %itemtypes%]");
        Skript.registerEvent(EvtBlock.class, BlockBurnEvent.class, "burn[ing] [[of] %itemtypes%]");
        Skript.registerEvent(EvtBlock.class, Skript.array(BlockPlaceEvent.class, PaintingPlaceEvent.class, PlayerBucketEmptyEvent.class), "plac(e|ing) [[of] %itemtypes%]");
        Skript.registerEvent(EvtBlock.class, BlockFadeEvent.class, "fad(e|ing) [[of] %itemtypes%]");
        Skript.registerEvent(EvtBlock.class, BlockFormEvent.class, "form[ing] [[of] %itemtypes%]");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.types = args[0];
        this.mine = parser.expr.toLowerCase().startsWith("min");
        return true;
    }

    @Override
    public boolean check(Event e) {
        byte durability;
        int id;
        if (this.mine && e instanceof BlockBreakEvent && ((BlockBreakEvent)e).getBlock().getDrops(((BlockBreakEvent)e).getPlayer().getItemInHand()).isEmpty()) {
            return false;
        }
        if (this.types == null) {
            return true;
        }
        if (e instanceof BlockEvent) {
            id = ((BlockEvent)e).getBlock().getTypeId();
            durability = ((BlockEvent)e).getBlock().getData();
        } else if (e instanceof BlockFormEvent) {
            id = ((BlockFormEvent)e).getNewState().getTypeId();
            durability = ((BlockFormEvent)e).getNewState().getRawData();
        } else if (e instanceof PlayerBucketFillEvent) {
            id = ((PlayerBucketEvent)e).getBlockClicked().getRelative(((PlayerBucketEvent)e).getBlockFace()).getTypeId();
            durability = ((PlayerBucketEvent)e).getBlockClicked().getRelative(((PlayerBucketEvent)e).getBlockFace()).getData();
        } else if (e instanceof PlayerBucketEmptyEvent) {
            id = ((PlayerBucketEmptyEvent)e).getBucket() == Material.WATER_BUCKET ? Material.STATIONARY_WATER.getId() : Material.STATIONARY_LAVA.getId();
            durability = 0;
        } else if (e instanceof PaintingEvent) {
            id = Material.PAINTING.getId();
            durability = 0;
        } else {
            throw new IllegalStateException();
        }
        return this.types.check(e, new Checker<ItemType>(){

            @Override
            public boolean check(ItemType t) {
                return t.isOfType(id, durability);
            }
        });
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "break/place/burn/fade/form of " + Skript.toString(this.types);
    }
}

