/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.events.ScheduledEvent;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.util.Time;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class EvtAtTime
extends SelfRegisteringSkriptEvent
implements Comparable<EvtAtTime> {
    private static final long serialVersionUID = 6716577116757409844L;
    private static final int CHECKPERIOD = 10;
    private static final HashMap<World, EvtAtInfo> triggers;
    private Trigger t;
    private int tick;
    private transient World[] worlds;
    private String[] worldNames = null;
    private static int taskID;

    static {
        Skript.registerEvent(EvtAtTime.class, ScheduledEvent.class, "at %time% [in %worlds%]");
        triggers = new HashMap();
        taskID = -1;
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.tick = ((Time)args[0].getSingle()).getTicks();
        World[] worldArray = this.worlds = args[1] == null ? Bukkit.getWorlds().toArray(new World[0]) : (World[])args[1].getAll();
        if (args[1] != null) {
            this.worldNames = new String[this.worlds.length];
            int i = 0;
            while (i < this.worlds.length) {
                this.worldNames[i] = this.worlds[i].getName();
                ++i;
            }
        }
        return true;
    }

    private static void registerListener() {
        if (taskID != -1) {
            return;
        }
        taskID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Skript.getInstance(), new Runnable(){

            @Override
            public void run() {
                for (Map.Entry e : triggers.entrySet()) {
                    boolean midnight;
                    EvtAtInfo i = (EvtAtInfo)e.getValue();
                    int tick = (int)((World)e.getKey()).getTime();
                    if (i.lastTick == tick) continue;
                    if (i.lastTick + 20 < tick || i.lastTick > tick && i.lastTick - 24000 + 20 < tick) {
                        i.lastTick = tick - 10;
                        if (i.lastTick < 0) {
                            i.lastTick += 24000;
                        }
                    }
                    boolean bl = midnight = i.lastTick > tick;
                    if (midnight) {
                        i.lastTick -= 24000;
                    }
                    int lastIndex = i.currentIndex;
                    do {
                        int nextTick;
                        EvtAtTime next = i.list.get(i.currentIndex);
                        int n = nextTick = midnight && next.tick > 12000 ? next.tick - 24000 : next.tick;
                        if (i.lastTick >= nextTick || nextTick > tick) break;
                        next.execute((World)e.getKey());
                        ++i.currentIndex;
                        if (i.currentIndex != i.list.size()) continue;
                        i.currentIndex = 0;
                    } while (i.currentIndex != lastIndex);
                    i.lastTick = tick;
                }
            }
        }, 10L, 10L);
    }

    private void execute(World w) {
        ScheduledEvent e = new ScheduledEvent(w);
        SkriptEventHandler.logEventStart(e);
        SkriptEventHandler.logTriggerEnd(this.t);
        this.t.start(e);
        SkriptEventHandler.logTriggerEnd(this.t);
        SkriptEventHandler.logEventEnd();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.worldNames == null) {
            this.worlds = Bukkit.getWorlds().toArray(new World[0]);
        } else {
            this.worlds = new World[this.worldNames.length];
            int i = 0;
            while (i < this.worlds.length) {
                this.worlds[i] = Bukkit.getWorld((String)this.worldNames[i]);
                if (this.worlds[i] == null) {
                    throw new IOException();
                }
                ++i;
            }
        }
    }

    @Override
    public void register(Trigger t) {
        this.t = t;
        World[] worldArray = this.worlds;
        int n = this.worlds.length;
        int n2 = 0;
        while (n2 < n) {
            World w = worldArray[n2];
            EvtAtInfo i = triggers.get(w);
            if (i == null) {
                i = new EvtAtInfo();
                triggers.put(w, i);
                i.lastTick = (int)w.getTime() - 1;
            }
            i.list.add(this);
            Collections.sort(i.list);
            ++n2;
        }
        EvtAtTime.registerListener();
    }

    @Override
    public void unregister(Trigger t) {
        Iterator<EvtAtInfo> iter = triggers.values().iterator();
        while (iter.hasNext()) {
            EvtAtInfo i = iter.next();
            i.list.remove(this);
            if (!i.list.isEmpty()) continue;
            iter.remove();
        }
        if (triggers.isEmpty()) {
            this.unregisterAll();
        }
    }

    @Override
    public void unregisterAll() {
        if (taskID != -1) {
            Bukkit.getScheduler().cancelTask(taskID);
        }
        taskID = -1;
        triggers.clear();
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "at " + Time.toString(this.tick) + " in worlds " + Skript.toString(this.worlds, true);
    }

    @Override
    public boolean check(Event e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(EvtAtTime e) {
        return this.tick - e.tick;
    }

    private static final class EvtAtInfo {
        int lastTick;
        int currentIndex;
        ArrayList<EvtAtTime> list = new ArrayList();

        private EvtAtInfo() {
        }
    }
}

