/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Utils;
import ch.njol.util.StringUtils;
import org.bukkit.Location;
import org.bukkit.entity.Villager;

public class VillagerData
extends EntityData<Villager> {
    private static final long serialVersionUID = -6472488986043622652L;
    private Villager.Profession profession = null;
    private boolean plural;

    static {
        VillagerData.register(VillagerData.class, "villager", Villager.class, "villager[s]", "farmer[s]", "librarian[s]", "priest[s]", "[black]smith[s]", "butcher[s]");
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (matchedPattern > 0) {
            this.profession = Villager.Profession.getProfession((int)(matchedPattern - 1));
        }
        this.plural = StringUtils.endsWithIgnoreCase(parseResult.expr, "s");
        return true;
    }

    @Override
    public void set(Villager entity) {
        if (this.profession != null) {
            entity.setProfession(this.profession);
        }
    }

    @Override
    public Villager spawn(Location loc) {
        Villager v = (Villager)super.spawn(loc);
        if (this.profession == null) {
            v.setProfession(Utils.random(Villager.Profession.values()));
        }
        return v;
    }

    @Override
    protected boolean match(Villager entity) {
        return this.profession == null || entity.getProfession() == this.profession;
    }

    @Override
    public Class<? extends Villager> getType() {
        return Villager.class;
    }

    @Override
    public String toString() {
        return this.profession == null ? "villager" : this.profession.toString().toLowerCase();
    }

    @Override
    public boolean isPlural() {
        return this.plural;
    }

    @Override
    public int hashCode() {
        return this.profession == null ? 0 : this.profession.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VillagerData)) {
            return false;
        }
        VillagerData other = (VillagerData)obj;
        return this.profession == other.profession;
    }

    @Override
    public String serialize() {
        return this.profession == null ? "" : this.profession.name();
    }

    @Override
    protected boolean deserialize(String s) {
        if (s.isEmpty()) {
            return true;
        }
        try {
            this.profession = Villager.Profession.valueOf((String)s);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

