/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.StringUtils;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Slime;

public class SlimeData
extends EntityData<Slime> {
    private static final long serialVersionUID = 5997881858144349614L;
    private boolean magma;
    private boolean plural;

    static {
        SlimeData.register(SlimeData.class, "slime", Slime.class, "slime[s]", "magma cube[s]");
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.magma = matchedPattern == 1;
        this.plural = StringUtils.endsWithIgnoreCase(parseResult.expr, "s");
        return true;
    }

    @Override
    public void set(Slime entity) {
    }

    @Override
    protected boolean match(Slime entity) {
        return this.magma == entity instanceof MagmaCube;
    }

    @Override
    public Class<? extends Slime> getType() {
        return this.magma ? MagmaCube.class : Slime.class;
    }

    @Override
    public String toString() {
        return this.magma ? "magma cube" : "slime";
    }

    @Override
    public boolean isPlural() {
        return this.plural;
    }

    @Override
    public int hashCode() {
        return this.magma ? 1 : -1;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlimeData)) {
            return false;
        }
        SlimeData other = (SlimeData)obj;
        return this.magma == other.magma;
    }

    @Override
    public String serialize() {
        return "" + this.magma;
    }

    @Override
    protected boolean deserialize(String s) {
        if (s.equalsIgnoreCase("true")) {
            this.magma = true;
            return true;
        }
        if (s.equalsIgnoreCase("false")) {
            this.magma = false;
            return true;
        }
        return false;
    }
}

