/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.StringUtils;
import org.bukkit.entity.Ocelot;

public class OcelotData
extends EntityData<Ocelot> {
    private static final long serialVersionUID = -7803473515795672650L;
    int tamed = 0;
    private boolean plural;

    static {
        EntityData.register(OcelotData.class, "ocelot", Ocelot.class, "(wild|untamed|unowned) ocelot[s]", "ocelot[s]", "([(tamed|owned)] cat|(tamed|owned) ocelot)[s]");
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.tamed = matchedPattern - 1;
        this.plural = StringUtils.endsWithIgnoreCase(parseResult.expr, "s");
        return true;
    }

    @Override
    public void set(Ocelot entity) {
        if (this.tamed != 0) {
            entity.setTamed(this.tamed == 1);
        }
    }

    @Override
    protected boolean match(Ocelot entity) {
        return this.tamed == 0 || entity.isTamed() == (this.tamed == 1);
    }

    @Override
    public Class<? extends Ocelot> getType() {
        return Ocelot.class;
    }

    @Override
    public String toString() {
        return this.tamed == -1 ? "wild ocelot" : (this.tamed == 1 ? "cat" : "ocelot");
    }

    @Override
    public boolean isPlural() {
        return this.plural;
    }

    @Override
    public int hashCode() {
        return this.tamed;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OcelotData)) {
            return false;
        }
        OcelotData other = (OcelotData)obj;
        return this.tamed == other.tamed;
    }

    @Override
    public String serialize() {
        return "" + this.tamed;
    }

    @Override
    protected boolean deserialize(String s) {
        try {
            this.tamed = Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

