/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Slot;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class EffHealth
extends Effect {
    private static final long serialVersionUID = 6404302201372383022L;
    private Expression<?> damageables;
    private Expression<Number> damage;
    private boolean heal = false;

    static {
        Skript.registerEffect(EffHealth.class, "damage %slots% by %number%", "damage %livingentities% by %number% [heart[s]]", "heal %livingentities% [by %-number% [heart[s]]]", "repair %slots% [by %-number%]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, int isDelayed, SkriptParser.ParseResult parser) {
        this.damageables = vars[0];
        this.damage = vars[1];
        this.heal = matchedPattern >= 2;
        return true;
    }

    @Override
    public void execute(Event e) {
        double damage = 0.0;
        if (this.damage != null) {
            Number n = this.damage.getSingle(e);
            if (n == null) {
                return;
            }
            damage = n.doubleValue();
        }
        ?[] objArray = this.damageables.getArray(e);
        int n = objArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object damageable = objArray[n2];
            if (damageable instanceof Slot) {
                ItemStack is = ((Slot)damageable).getItem();
                if (this.damage == null) {
                    is.setDurability((short)0);
                } else {
                    is.setDurability((short)Math.max(0.0, (double)is.getDurability() + (this.heal ? -damage : damage)));
                    if (is.getDurability() >= is.getType().getMaxDurability()) {
                        is = null;
                    }
                }
                ((Slot)damageable).setItem(is);
            } else if (damageable instanceof LivingEntity) {
                if (this.damage == null) {
                    ((LivingEntity)damageable).setHealth(((LivingEntity)damageable).getMaxHealth());
                } else if (!this.heal) {
                    ((LivingEntity)damageable).damage((int)Math.round(2.0 * damage));
                } else {
                    ((LivingEntity)damageable).setHealth(Math.max(0, Math.min(((LivingEntity)damageable).getMaxHealth(), ((LivingEntity)damageable).getHealth() + (int)Math.round(2.0 * damage))));
                }
            }
            ++n2;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.heal ? "heal " : "damage ") + this.damageables.toString(e, debug) + (this.damage == null ? "" : " by " + this.damage.toString(e, debug));
    }
}

