/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.util.Timespan;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class Delay
extends Effect {
    private static final long serialVersionUID = -6754842737504578386L;
    private Expression<Timespan> duration;
    private static final Set<Event> delayed;

    static {
        Skript.registerEffect(Delay.class, "(wait|halt) [for] %timespan%");
        delayed = Collections.newSetFromMap(new WeakHashMap());
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        this.duration = exprs[0];
        return true;
    }

    @Override
    protected TriggerItem walk(final Event e) {
        this.debug(e, true);
        final long start = System.nanoTime();
        if (this.getNext() != null) {
            delayed.add(e);
            Timespan d = this.duration.getSingle(e);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                @Override
                public void run() {
                    if (Skript.debug()) {
                        Skript.info(String.valueOf(Delay.this.getIndentation()) + "... continuing after " + (double)(System.nanoTime() - start) / 1.0E9 + "s");
                    }
                    TriggerItem.walk(Delay.this.getNext(), e);
                }
            }, (long)(d == null ? 0 : d.getTicks()));
        }
        return null;
    }

    public static final boolean isDelayed(Event e) {
        return delayed.contains(e);
    }

    @Override
    protected void execute(Event e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "wait for " + this.duration.toString(e, debug) + (e == null ? "" : "...");
    }
}

