/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class ConfigReader
extends BufferedReader {
    private String line;
    private String lastLine;
    private boolean reset = false;
    private int ln = 0;
    private boolean hasNonEmptyLine = false;

    public ConfigReader(InputStream source) throws UnsupportedEncodingException {
        super(new InputStreamReader(source, "UTF-8"));
    }

    @Override
    public String readLine() throws IOException {
        if (this.reset) {
            this.reset = false;
            return this.lastLine;
        }
        this.lastLine = this.line;
        this.line = this.stripUTF8BOM(super.readLine());
        ++this.ln;
        return this.line;
    }

    private final String stripUTF8BOM(String line) {
        if (!this.hasNonEmptyLine && line != null && !line.isEmpty()) {
            this.hasNonEmptyLine = true;
            if (line.startsWith("\u00ef\u00bb\u00bf")) {
                return line.substring(3);
            }
            if (line.startsWith("\ufeff")) {
                return line.substring(1);
            }
        }
        return line;
    }

    @Override
    public void reset() throws IOException {
        if (this.reset) {
            throw new IOException("reset was called twice without a readLine inbetween");
        }
        this.reset = true;
    }

    public int getLineNum() {
        return this.ln;
    }

    public String getLine() {
        return this.line;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

