/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.Aliases;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.EnumParser;
import ch.njol.skript.classes.EnumSerializer;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.classes.data.DefaultChangers;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.PotionEffectUtils;
import ch.njol.skript.util.StringMode;
import ch.njol.skript.util.Utils;
import ch.njol.util.StringUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class BukkitClasses {
    static {
        Skript.registerClass(new ClassInfo<Entity>(Entity.class, "entity", "entity").defaultExpression(new EventValueExpression<Entity>(Entity.class)).parser(new Parser<Entity>(){

            @Override
            public Entity parse(String s, ParseContext context) {
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toVariableNameString(Entity e) {
                return "entity:" + e.getUniqueId().toString();
            }

            @Override
            public String getVariableNamePattern() {
                return "entity:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}";
            }

            @Override
            public String toString(Entity e) {
                return EntityData.toString(e);
            }
        }).changer(DefaultChangers.entityChanger));
        Skript.registerClass(new ClassInfo<LivingEntity>(LivingEntity.class, "livingentity", "living entity").defaultExpression(new EventValueExpression<LivingEntity>(LivingEntity.class)).changer(DefaultChangers.entityChanger));
        Skript.registerClass(new ClassInfo<Projectile>(Projectile.class, "projectile", "projectile").defaultExpression(new EventValueExpression<Projectile>(Projectile.class)).changer(DefaultChangers.nonLivingEntityChanger));
        Skript.registerClass(new ClassInfo<Block>(Block.class, "block", "block").user("block").defaultExpression(new EventValueExpression<Block>(Block.class)).parser(new Parser<Block>(){

            @Override
            public Block parse(String s, ParseContext context) {
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toString(Block b) {
                return ItemType.toString(new ItemStack(b.getTypeId(), 1, (short)b.getState().getRawData()));
            }

            @Override
            public String toVariableNameString(Block b) {
                return String.valueOf(b.getWorld().getName()) + ":" + b.getX() + "," + b.getY() + "," + b.getZ();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S:-?\\d+,-?\\d+,-?\\d+";
            }

            @Override
            public String getDebugMessage(Block b) {
                return String.valueOf(this.toString(b)) + " block (" + b.getWorld().getName() + ":" + b.getX() + "," + b.getY() + "," + b.getZ() + ")";
            }
        }).changer(DefaultChangers.blockChanger).serializer(new Serializer<Block>(){

            @Override
            public String serialize(Block b) {
                return String.valueOf(b.getWorld().getName()) + ":" + b.getX() + "," + b.getY() + "," + b.getZ();
            }

            @Override
            public Block deserialize(String s) {
                String[] split = s.split("[:,]");
                if (split.length != 4) {
                    return null;
                }
                World w = Bukkit.getWorld((String)split[0]);
                if (w == null) {
                    return null;
                }
                try {
                    int[] l = new int[3];
                    int i = 0;
                    while (i < 3) {
                        l[i] = Integer.parseInt(split[i + 1]);
                        ++i;
                    }
                    return w.getBlockAt(l[0], l[1], l[2]);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        Skript.registerClass(new ClassInfo<Location>(Location.class, "location", "location").defaultExpression(new EventValueExpression<Location>(Location.class)).parser(new Parser<Location>(){

            @Override
            public Location parse(String s, ParseContext context) {
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toString(Location l) {
                return "x: " + StringUtils.toString(l.getX(), 2) + ", y: " + StringUtils.toString(l.getY(), 2) + ", z: " + StringUtils.toString(l.getZ(), 2);
            }

            @Override
            public String toVariableNameString(Location l) {
                return String.valueOf(l.getWorld().getName()) + ":" + l.getX() + "," + l.getY() + "," + l.getZ();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S:-?\\d+(\\.\\d+)?,-?\\d+(\\.\\d+)?,-?\\d+(\\.\\d+)?";
            }

            @Override
            public String getDebugMessage(Location l) {
                return "(" + l.getWorld().getName() + ":" + l.getX() + "," + l.getY() + "," + l.getZ() + "|yaw=" + l.getYaw() + "/pitch=" + l.getPitch() + ")";
            }
        }).serializer(new Serializer<Location>(){

            @Override
            public String serialize(Location l) {
                return String.valueOf(l.getWorld().getName()) + ":" + l.getX() + "," + l.getY() + "," + l.getZ() + "|" + l.getYaw() + "/" + l.getPitch();
            }

            @Override
            public Location deserialize(String s) {
                String[] split = s.split("[:,|/]");
                if (split.length != 6) {
                    return null;
                }
                World w = Bukkit.getWorld((String)split[0]);
                if (w == null) {
                    return null;
                }
                try {
                    double[] l = new double[5];
                    int i = 0;
                    while (i < 5) {
                        l[i] = Double.parseDouble(split[i + 1]);
                        ++i;
                    }
                    return new Location(w, l[0], l[1], l[2], (float)l[3], (float)l[4]);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        Skript.registerClass(new ClassInfo<World>(World.class, "world", "world").user("worlds?").before("string").defaultExpression(new EventValueExpression<World>(World.class)).parser(new Parser<World>(){

            @Override
            public World parse(String s, ParseContext context) {
                if (context == ParseContext.COMMAND) {
                    return Bukkit.getWorld((String)s);
                }
                if (!s.matches("\".+\"")) {
                    return null;
                }
                return Bukkit.getWorld((String)s.substring(1, s.length() - 1));
            }

            @Override
            public String toString(World w) {
                return w.getName();
            }

            @Override
            public String toVariableNameString(World o) {
                return o.getName();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S+";
            }
        }).serializer(new Serializer<World>(){

            @Override
            public String serialize(World w) {
                return w.getName();
            }

            @Override
            public World deserialize(String s) {
                return Bukkit.getWorld((String)s);
            }
        }));
        Skript.registerClass(new ClassInfo<Inventory>(Inventory.class, "inventory", "inventory").defaultExpression(new EventValueExpression<Inventory>(Inventory.class)).parser(new Parser<Inventory>(){

            @Override
            public Inventory parse(String s, ParseContext context) {
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toString(Inventory i) {
                return "inventory of " + Skript.toString(i.getHolder());
            }

            @Override
            public String getDebugMessage(Inventory i) {
                return "inventory of " + Skript.getDebugMessage(i.getHolder());
            }

            @Override
            public String toVariableNameString(Inventory o) {
                return "inventory of " + Skript.toString(o.getHolder(), StringMode.VARIABLE_NAME, false);
            }

            @Override
            public String getVariableNamePattern() {
                return "inventory of .+";
            }
        }).changer(DefaultChangers.inventoryChanger));
        Skript.registerClass(new ClassInfo<Player>(Player.class, "player", "player").user("players?").defaultExpression(new EventValueExpression<Player>(Player.class)).after("string").parser(new Parser<Player>(){

            @Override
            public Player parse(String s, ParseContext context) {
                if (context == ParseContext.COMMAND) {
                    List ps = Bukkit.matchPlayer((String)s);
                    if (ps.size() == 1) {
                        return (Player)ps.get(0);
                    }
                    if (ps.size() == 0) {
                        Skript.error("There is no player online whose name starts with '" + s + "'");
                    } else {
                        Skript.error("There are several players online whose names start with '" + s + "'");
                    }
                    return null;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return context == ParseContext.COMMAND;
            }

            @Override
            public String toString(Player p) {
                return String.valueOf(p.getDisplayName()) + ChatColor.RESET;
            }

            @Override
            public String toCommandString(Player p) {
                return p.getName();
            }

            @Override
            public String toVariableNameString(Player p) {
                return p.getName();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S+";
            }

            @Override
            public String getDebugMessage(Player p) {
                return String.valueOf(p.getName()) + " " + Skript.getDebugMessage(p.getLocation());
            }
        }).changer(DefaultChangers.playerChanger).serializeAs(OfflinePlayer.class));
        Skript.registerClass(new ClassInfo<OfflinePlayer>(OfflinePlayer.class, "offlineplayer", "player").user("offline ?players?").defaultExpression(new EventValueExpression<OfflinePlayer>(OfflinePlayer.class)).after("string").parser(new Parser<OfflinePlayer>(){

            @Override
            public OfflinePlayer parse(String s, ParseContext context) {
                if (context == ParseContext.COMMAND) {
                    if (!s.matches("\\S+")) {
                        return null;
                    }
                    return Bukkit.getOfflinePlayer((String)s);
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return context == ParseContext.COMMAND;
            }

            @Override
            public String toString(OfflinePlayer p) {
                if (p.isOnline()) {
                    return String.valueOf(p.getPlayer().getDisplayName()) + ChatColor.RESET;
                }
                return p.getName();
            }

            @Override
            public String toCommandString(OfflinePlayer p) {
                return p.getName();
            }

            @Override
            public String toVariableNameString(OfflinePlayer p) {
                return p.getName();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S+";
            }

            @Override
            public String getDebugMessage(OfflinePlayer p) {
                if (p.isOnline()) {
                    return Skript.getDebugMessage(p.getPlayer());
                }
                return p.getName();
            }
        }).serializer(new Serializer<OfflinePlayer>(){

            @Override
            public String serialize(OfflinePlayer p) {
                return p.getName();
            }

            @Override
            public OfflinePlayer deserialize(String s) {
                return Bukkit.getOfflinePlayer((String)s);
            }
        }));
        Skript.registerClass(new ClassInfo<CommandSender>(CommandSender.class, "commandsender", "player/console").defaultExpression(new EventValueExpression<CommandSender>(CommandSender.class)).parser(new Parser<CommandSender>(){

            @Override
            public CommandSender parse(String s, ParseContext context) {
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toString(CommandSender s) {
                return s.getName();
            }

            @Override
            public String toVariableNameString(CommandSender o) {
                return o.getName();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S+";
            }
        }));
        Skript.registerClass(new ClassInfo<BlockFace>(BlockFace.class, "blockface", "direction").user("directions?").parser(new Parser<BlockFace>(){

            @Override
            public BlockFace parse(String s, ParseContext context) {
                return Utils.getBlockFace(s, true);
            }

            @Override
            public String toString(BlockFace o) {
                return o.toString().toLowerCase().replace('_', ' ');
            }

            @Override
            public String toVariableNameString(BlockFace o) {
                return o.toString().toLowerCase(Locale.ENGLISH).replace('_', ' ');
            }

            @Override
            public String getVariableNamePattern() {
                return "[a-z ]+";
            }
        }).serializer(new EnumSerializer<BlockFace>(BlockFace.class)));
        Skript.registerClass(new ClassInfo<InventoryHolder>(InventoryHolder.class, "inventoryholder", "inventory holder").defaultExpression(new EventValueExpression<InventoryHolder>(InventoryHolder.class)));
        Skript.registerClass(new ClassInfo<GameMode>(GameMode.class, "gamemode", "game mode").user("game ?modes?").defaultExpression(new SimpleLiteral<GameMode>(GameMode.SURVIVAL, true)).parser(new Parser<GameMode>(){

            @Override
            public GameMode parse(String s, ParseContext context) {
                try {
                    return GameMode.valueOf((String)s.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }

            @Override
            public String toString(GameMode m) {
                return m.toString().toLowerCase();
            }

            @Override
            public String toVariableNameString(GameMode o) {
                return o.toString().toLowerCase(Locale.ENGLISH);
            }

            @Override
            public String getVariableNamePattern() {
                return "[a-z]+";
            }
        }).serializer(new EnumSerializer<GameMode>(GameMode.class)));
        Skript.registerClass(new ClassInfo<ItemStack>(ItemStack.class, "itemstack", "material").user("item", "material").after("number").parser(new Parser<ItemStack>(){

            @Override
            public ItemStack parse(String s, ParseContext context) {
                ItemType t = Aliases.parseItemType(s);
                if (t == null) {
                    return null;
                }
                if ((t = t.getItem()).numTypes() != 1) {
                    Skript.error("'" + s + "' represents multiple materials");
                    return null;
                }
                if (!t.getTypes().get(0).hasDataRange()) {
                    return t.getRandom();
                }
                if (t.getTypes().get((int)0).dataMin > 0) {
                    Skript.error("'" + s + "' represents multiple materials");
                    return null;
                }
                ItemStack i = t.getRandom();
                i.setDurability((short)0);
                return i;
            }

            @Override
            public String toString(ItemStack i) {
                return ItemType.toString(i);
            }

            @Override
            public String toVariableNameString(ItemStack i) {
                StringBuilder b = new StringBuilder("item:");
                b.append(i.getType().name());
                b.append(":" + i.getDurability());
                b.append("*" + i.getAmount());
                for (Map.Entry e : i.getEnchantments().entrySet()) {
                    b.append("#" + ((Enchantment)e.getKey()).getId());
                    b.append(":" + e.getValue());
                }
                return b.toString();
            }

            @Override
            public String getVariableNamePattern() {
                return "item:.+";
            }
        }).serializer(new Serializer<ItemStack>(){

            @Override
            public String serialize(ItemStack i) {
                StringBuilder b = new StringBuilder();
                b.append(i.getTypeId());
                b.append(":" + i.getDurability());
                b.append("*" + i.getAmount());
                for (Map.Entry e : i.getEnchantments().entrySet()) {
                    b.append("#" + ((Enchantment)e.getKey()).getId());
                    b.append(":" + e.getValue());
                }
                return b.toString();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ItemStack deserialize(String s) {
                String[] split = s.split("[:*#]");
                if (split.length < 3 || split.length % 2 != 1) {
                    return null;
                }
                int typeId = -1;
                try {
                    typeId = Material.valueOf((String)split[0]).getId();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                try {
                    ItemStack is = new ItemStack(typeId == -1 ? Integer.parseInt(split[0]) : typeId, Integer.parseInt(split[2]), Short.parseShort(split[1]));
                    int i = 3;
                    while (true) {
                        if (i >= split.length) {
                            return is;
                        }
                        Enchantment ench = Enchantment.getById((int)Integer.parseInt(split[i]));
                        if (ench == null) {
                            return null;
                        }
                        is.addUnsafeEnchantment(ench, Integer.parseInt(split[i + 1]));
                        i += 2;
                    }
                }
                catch (NumberFormatException e) {
                    return null;
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
        }));
        Skript.registerClass(new ClassInfo<Biome>(Biome.class, "biome", "biome").user("biomes?").parser(new EnumParser<Biome>(Biome.class)).serializer(new EnumSerializer<Biome>(Biome.class)));
        Skript.registerClass(new ClassInfo<PotionEffectType>(PotionEffectType.class, "potioneffecttype", "potion").user("potions?( ?effects?)?( ?types?)?").parser(new Parser<PotionEffectType>(){

            @Override
            public PotionEffectType parse(String s, ParseContext context) {
                return PotionEffectUtils.parse(s);
            }

            @Override
            public String toString(PotionEffectType o) {
                return PotionEffectUtils.toString(o);
            }

            @Override
            public String toVariableNameString(PotionEffectType o) {
                return o.getName();
            }

            @Override
            public String getVariableNamePattern() {
                return ".+";
            }
        }).serializer(new Serializer<PotionEffectType>(){

            @Override
            public String serialize(PotionEffectType o) {
                return o.getName();
            }

            @Override
            public PotionEffectType deserialize(String s) {
                return PotionEffectType.getByName((String)s);
            }
        }));
    }
}

