/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Config;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class Language {
    private static String name = "english";
    private static HashMap<String, String> english = new HashMap();
    private static HashMap<String, String> englishPlurals = new HashMap();
    private static HashMap<String, String> localized;
    private static HashMap<String, String> localizedPlurals;
    private static boolean useLocal;
    private static final Pattern split;
    private static final Collection<LanguageChangeListener> listeners;

    static {
        useLocal = false;
        split = Pattern.compile("\\s*,\\s*");
        listeners = new ArrayList<LanguageChangeListener>();
    }

    public static String getName() {
        return name;
    }

    private static final String get_i(String key) {
        String s;
        if (useLocal && localized != null && (s = localized.get(key)) != null) {
            return s;
        }
        return english.get(key);
    }

    public static String get(String key) {
        String s = Language.get_i(key.toLowerCase(Locale.ENGLISH));
        if (s == null) {
            return key.toLowerCase(Locale.ENGLISH);
        }
        return s;
    }

    public static String getPlural(String key) {
        String s;
        if (useLocal && localized != null) {
            s = localizedPlurals.get(key);
            if (s != null) {
                return s;
            }
            s = localized.get(key);
            if (s != null) {
                return s;
            }
        }
        if ((s = englishPlurals.get(key)) != null) {
            return s;
        }
        s = english.get(key);
        if (s != null) {
            return s;
        }
        return key;
    }

    public static String format(String key, Object ... args) {
        String value = Language.get_i(key = key.toLowerCase(Locale.ENGLISH));
        if (value == null) {
            return key;
        }
        try {
            return String.format(value, args);
        }
        catch (Exception e) {
            return key;
        }
    }

    public static String getSpaced(String key) {
        String s = Language.get(key.toLowerCase(Locale.ENGLISH));
        if (s.isEmpty()) {
            return " ";
        }
        return " " + s + " ";
    }

    public static String[] getList(String key) {
        String s = Language.get_i(key.toLowerCase(Locale.ENGLISH));
        if (s == null) {
            return new String[]{key.toLowerCase(Locale.ENGLISH)};
        }
        return split.split(s);
    }

    static void loadDefault() {
        InputStream din = Skript.getInstance().getResource("lang/english.lang");
        if (din == null) {
            throw new IllegalStateException("Skript.jar is missing the required english.lang file!");
        }
        try {
            try {
                english = new Config(din, "english.lang", false, false, ":").toMap(".");
            }
            catch (IOException e) {
                throw Skript.exception(e, "Could not load the default language file!");
            }
        }
        finally {
            try {
                din.close();
            }
            catch (IOException iOException) {}
        }
        Language.makePlurals(english, englishPlurals);
        for (LanguageChangeListener l : listeners) {
            l.onLanguageChange();
        }
    }

    static boolean load(String name) {
        name = name.toLowerCase();
        InputStream in = Skript.getInstance().getResource("lang/" + name + ".lang");
        if (in == null) {
            return false;
        }
        try {
            try {
                localized = new Config(in, String.valueOf(name) + ".lang", false, false, ":").toMap(".");
            }
            catch (IOException e) {
                Skript.exception(e, "Could not load the language file '" + name + ".lang'!");
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        localizedPlurals = new HashMap();
        Language.makePlurals(localized, localizedPlurals);
        Language.name = name;
        if (useLocal) {
            for (LanguageChangeListener l : listeners) {
                l.onLanguageChange();
            }
        }
        return true;
    }

    private static final void makePlurals(HashMap<String, String> lang, HashMap<String, String> plurals) {
        for (Map.Entry<String, String> e : lang.entrySet()) {
            String s = e.getValue();
            int c = s.indexOf("\u00a6");
            if (c == -1) continue;
            int c2 = s.indexOf("\u00a6", c + 1);
            if (c2 == -1) {
                e.setValue(s.substring(0, c));
            } else {
                e.setValue(String.valueOf(s.substring(0, c)) + s.substring(c + 1, c2));
            }
            plurals.put(e.getKey(), String.valueOf(s.substring(0, c)) + s.substring((c2 == -1 ? c : c2) + 1));
        }
    }

    public static void addListener(LanguageChangeListener l) {
        listeners.add(l);
        if (english != null) {
            l.onLanguageChange();
        }
    }

    public static void setUseLocal(boolean b) {
        if (useLocal == b) {
            return;
        }
        useLocal = b;
        for (LanguageChangeListener l : listeners) {
            l.onLanguageChange();
        }
    }

    public static interface LanguageChangeListener {
        public void onLanguageChange();
    }
}

