/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Language;
import ch.njol.skript.util.Utils;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.block.Block;

public enum StructureType {
    TREE(TreeType.TREE, TreeType.BIG_TREE, TreeType.REDWOOD, TreeType.TALL_REDWOOD, TreeType.SMALL_JUNGLE, TreeType.JUNGLE, TreeType.SWAMP),
    REGULAR(TreeType.TREE, TreeType.BIG_TREE),
    SMALL_REGULAR(TreeType.TREE),
    BIG_REGULAR(TreeType.BIG_TREE),
    REDWOOD(TreeType.REDWOOD, TreeType.TALL_REDWOOD),
    SMALL_REDWOOD(TreeType.REDWOOD),
    BIG_REDWOOD(TreeType.TALL_REDWOOD),
    JUNGLE(TreeType.SMALL_JUNGLE, TreeType.JUNGLE),
    SMALL_JUNGLE(TreeType.SMALL_JUNGLE),
    BIG_JUNGLE(TreeType.JUNGLE),
    JUNGLE_BUSH(TreeType.JUNGLE_BUSH),
    SWAMP(TreeType.SWAMP),
    MUSHROOM(TreeType.RED_MUSHROOM, TreeType.BROWN_MUSHROOM),
    RED_MUSHROOM(TreeType.RED_MUSHROOM),
    BROWN_MUSHROOM(TreeType.BROWN_MUSHROOM);

    String name;
    private final TreeType[] types;
    private static final Map<String, StructureType> byName;

    static {
        byName = new HashMap<String, StructureType>();
        Language.addListener(new Language.LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                byName.clear();
                StructureType[] structureTypeArray = StructureType.values();
                int n = structureTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StructureType t = structureTypeArray[n2];
                    String[] names = Language.getList("treetypes." + t.name());
                    t.name = names[0];
                    String[] stringArray = names;
                    int n3 = names.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String name = stringArray[n4];
                        byName.put(name, t);
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
    }

    private StructureType(TreeType ... types) {
        this.types = types;
    }

    public void grow(Location loc) {
        loc.getWorld().generateTree(loc, Utils.random(this.types));
    }

    public void grow(Block b) {
        b.getWorld().generateTree(b.getLocation(), Utils.random(this.types));
    }

    public TreeType[] getTypes() {
        return this.types;
    }

    public String toString() {
        return this.name;
    }

    public static StructureType fromName(String s) {
        return byName.get(s.toLowerCase());
    }

    public boolean is(TreeType type) {
        return Utils.contains(this.types, type);
    }
}

