/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.log;

import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.config.Node;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.ParseLog;
import ch.njol.skript.log.SimpleLog;
import ch.njol.skript.log.SubLog;
import ch.njol.skript.log.Verbosity;
import ch.njol.util.Validate;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public abstract class SkriptLogger {
    private static Node node = null;
    private static Verbosity verbosity = Verbosity.NORMAL;
    static boolean debug;
    private static final Deque<SubLog> subLogs;
    private static int numErrors;

    static {
        subLogs = new LinkedList<SubLog>();
        numErrors = 0;
    }

    public static final SimpleLog startSubLog() {
        SimpleLog subLog = new SimpleLog();
        subLogs.addLast(subLog);
        return subLog;
    }

    public static final ParseLog startParseLog() {
        ParseLog subLog = new ParseLog();
        subLogs.addLast(subLog);
        return subLog;
    }

    public static final void stopSubLog(SubLog log) {
        if (!subLogs.contains(log)) {
            return;
        }
        if (subLogs.removeLast() != log) {
            int i = 1;
            while (subLogs.removeLast() != log) {
                ++i;
            }
            Bukkit.getLogger().severe("[Skript] " + i + " sub log(s) was/were not stopped properly! (at " + SkriptLogger.getCaller() + ")");
        }
    }

    static final StackTraceElement getCaller() {
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            if (!e.getClassName().startsWith(SkriptLogger.class.getPackage().getName())) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    public static void setVerbosity(Verbosity v) {
        verbosity = v;
        if (v.compareTo(Verbosity.DEBUG) >= 0) {
            debug = true;
        }
    }

    public static void setNode(Node node) {
        SkriptLogger.node = node == null || node.getParent() == null ? null : node;
    }

    public static Node getNode() {
        return node;
    }

    public static void log(Level level, String message) {
        SkriptLogger.log(new LogEntry(level, message, node));
    }

    public static void log(LogEntry entry) {
        Validate.notNull((Object)entry, "entry");
        if (!subLogs.isEmpty()) {
            subLogs.getLast().log(entry);
        } else {
            Bukkit.getLogger().log(entry.getLevel(), "[Skript] " + entry.getMessage());
            if (entry.getLevel() == Level.SEVERE) {
                ++numErrors;
            }
        }
    }

    public static void logAll(Collection<LogEntry> entries) {
        if (!subLogs.isEmpty()) {
            for (LogEntry e : entries) {
                subLogs.getLast().log(e);
            }
        } else {
            for (LogEntry entry : entries) {
                Validate.notNull(entry);
                Bukkit.getLogger().log(entry.getLevel(), "[Skript] " + entry.getMessage());
                if (entry.getLevel() != Level.SEVERE) continue;
                ++numErrors;
            }
        }
    }

    public static boolean log(Verbosity minVerb) {
        return minVerb.compareTo(verbosity) <= 0;
    }

    public static boolean debug() {
        return debug;
    }

    public static int getNumErrors() {
        int errors = numErrors;
        for (SubLog log : subLogs) {
            errors += log.getNumErrors();
        }
        return errors;
    }

    public static void error(LogEntry error, ErrorQuality quality) {
        if (error.getLevel() != Level.SEVERE) {
            throw new IllegalArgumentException("Cannot error anything else than an error");
        }
        if (!(subLogs.getLast() instanceof ParseLog)) {
            throw new SkriptAPIException("Cannot log with a quality if no parsing is in progress");
        }
        ((ParseLog)subLogs.getLast()).error(error, quality);
    }

    static void printParseLogError(LogEntry error, int quality) {
        if (subLogs.peekLast() instanceof ParseLog) {
            ((ParseLog)subLogs.getLast()).error(error, quality);
        } else {
            SkriptLogger.log(error);
        }
    }
}

