/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.log;

import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.log.SubLog;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class ParseLog
implements SubLog {
    private LogEntry error = null;
    private int quality = 0;
    private final List<LogEntry> log = new ArrayList<LogEntry>();

    @Override
    public void log(LogEntry entry) {
        if (entry.getLevel() == Level.SEVERE) {
            this.error(entry, ErrorQuality.SEMANTIC_ERROR);
        } else {
            this.log.add(entry);
        }
    }

    public void error(LogEntry error, ErrorQuality quality) {
        if (this.quality < quality.quality()) {
            this.quality = quality.quality();
            this.error = error;
        }
    }

    void error(LogEntry error, int quality) {
        if (this.quality < quality) {
            this.quality = quality;
            this.error = error;
        }
    }

    @Override
    public void clear() {
        this.log.clear();
    }

    @Override
    public void stop() {
        SkriptLogger.stopSubLog(this);
    }

    @Override
    public void printLog() {
        this.stop();
        SkriptLogger.logAll(this.log);
    }

    public void printError(String def) {
        this.stop();
        if (this.error == null && def == null) {
            return;
        }
        if (this.error == null) {
            SkriptLogger.printParseLogError(new LogEntry(Level.SEVERE, def), this.quality);
        } else {
            SkriptLogger.printParseLogError(this.error, this.quality);
        }
    }

    @Override
    public int getNumErrors() {
        return this.error == null ? 0 : 1;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public LogEntry getError() {
        return this.error;
    }
}

