/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.util;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Debuggable;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.StringMode;
import ch.njol.util.StringUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.event.Event;

public class VariableString
implements Debuggable,
Serializable {
    private static final long serialVersionUID = -2456868967246699395L;
    private final String name;
    private final Object[] string;
    private final boolean isSimple;
    private final String simple;
    private StringMode mode;
    public static final Map<String, Pattern> variableNames = new HashMap<String, Pattern>();

    private VariableString(String s, StringMode mode) {
        this.name = s;
        this.string = null;
        this.isSimple = true;
        this.simple = s;
        this.mode = mode;
    }

    private VariableString(String name, Object[] string, StringMode mode) {
        this.name = name;
        this.isSimple = false;
        this.simple = null;
        this.string = string;
        this.mode = mode;
    }

    public static VariableString newInstance(String s) {
        return VariableString.newInstance(s, StringMode.MESSAGE);
    }

    public static VariableString newInstance(String s, StringMode mode) {
        ArrayList<Object> string = new ArrayList<Object>();
        int c = s.indexOf(37);
        if (c != -1) {
            string.add(s.substring(0, c));
            while (c != s.length()) {
                int b;
                int c2 = s.indexOf(37, c + 1);
                int a = c;
                while (c2 != -1 && (b = s.indexOf(123, a + 1)) != -1 && b < c2) {
                    int b2 = VariableString.nextBracket(s, '}', '{', b + 1);
                    if (b2 == -1) {
                        Skript.error("Missing closing bracket '}' to end variable");
                        return null;
                    }
                    c2 = s.indexOf(37, b2 + 1);
                    a = b2;
                }
                if (c2 == -1) {
                    Skript.error("The percent sign is used for expressions (e.g. %player%). To insert a %, type it twice: %%.");
                    return null;
                }
                if (c + 1 == c2) {
                    string.add("%");
                } else {
                    Expression expr = (Expression)SkriptParser.parse(s.substring(c + 1, c2), Skript.getExpressions(), false, true, "can't understand the expression %" + s.substring(c + 1, c2) + "%");
                    if (expr == null) {
                        return null;
                    }
                    string.add(expr);
                }
                c = s.indexOf(37, c2 + 1);
                if (c == -1) {
                    c = s.length();
                }
                string.add(s.substring(c2 + 1, c));
            }
        } else {
            string.add(s);
        }
        VariableString.checkVariableConflicts(s, mode, string);
        if (c == -1) {
            return new VariableString(s, mode);
        }
        return new VariableString(s, string.toArray(), mode);
    }

    private static void checkVariableConflicts(String name, StringMode mode, Iterable<Object> string) {
        if (mode == StringMode.VARIABLE_NAME && !variableNames.containsKey(name)) {
            Pattern pattern;
            if (name.startsWith("%")) {
                Skript.warning("Starting a variable's name with an expression is discouraged ({" + name + "}). You could prefix it with the script's name: {" + StringUtils.substring(ScriptLoader.currentScript.getFileName(), 0, -3) + "." + name + "}");
            }
            if (string != null) {
                StringBuilder p = new StringBuilder();
                block0: for (Object o : string) {
                    if (o instanceof Expression) {
                        for (ClassInfo<?> ci : Skript.getClassInfos()) {
                            if (ci.getParser() == null || !ci.getC().isAssignableFrom(((Expression)o).getReturnType())) continue;
                            p.append("(?!%)" + ci.getParser().getVariableNamePattern() + "(?<!%)");
                            continue block0;
                        }
                        p.append("[^%](.*[^%])?");
                        continue;
                    }
                    p.append(Pattern.quote(o.toString()));
                }
                pattern = Pattern.compile(p.toString());
            } else {
                pattern = Pattern.compile(Pattern.quote(name));
            }
            if (!SkriptConfig.disableVariableConflictWarnings) {
                for (Map.Entry<String, Pattern> e : variableNames.entrySet()) {
                    if (!e.getValue().matcher(name).matches() && !pattern.matcher(e.getKey()).matches()) continue;
                    Skript.warning("Possible name conflict of variables {" + name + "} and {" + e.getKey() + "} (there might be more conflicts).");
                    break;
                }
            }
            variableNames.put(name, pattern);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        VariableString.checkVariableConflicts(this.name, this.mode, this.string == null ? null : Arrays.asList(this.string));
    }

    private static int nextBracket(String s, char closingBracket, char openingBracket, int start) {
        int n = 0;
        int i = start;
        while (i < s.length()) {
            if (s.charAt(i) == closingBracket) {
                if (n == 0) {
                    return i;
                }
                --n;
            } else if (s.charAt(i) == openingBracket) {
                ++n;
            }
            ++i;
        }
        return -1;
    }

    public static VariableString[] makeStrings(String[] args) {
        VariableString[] strings = new VariableString[args.length];
        int j = 0;
        int i = 0;
        while (i < args.length) {
            VariableString vs = VariableString.newInstance(args[i]);
            if (vs != null) {
                strings[j++] = vs;
            }
            ++i;
        }
        if (j != args.length) {
            return Arrays.copyOf(strings, j);
        }
        return strings;
    }

    public static VariableString[] makeStringsFromQuoted(List<String> args) {
        VariableString[] strings = new VariableString[args.size()];
        int i = 0;
        while (i < args.size()) {
            assert (args.get(i).startsWith("\"") && args.get(i).endsWith("\""));
            VariableString vs = VariableString.newInstance(args.get(i).substring(1, args.get(i).length() - 1));
            if (vs == null) {
                return null;
            }
            strings[i] = vs;
            ++i;
        }
        return strings;
    }

    public String toString(Event e) {
        if (this.isSimple) {
            return this.simple;
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.string.length) {
            Object o = this.string[i];
            if (o instanceof Expression) {
                b.append(Skript.toString(((Expression)o).getArray(e), ((Expression)o).getAnd(), this.mode, this.mode == StringMode.MESSAGE && (Math.abs(StringUtils.numberBefore(b, b.length() - 1)) != 1.0 || i + 1 < this.string.length && this.string[i + 1] instanceof String && StringUtils.startsWithIgnoreCase((String)this.string[i + 1], "s"))));
            } else if (this.mode == StringMode.MESSAGE && i != 0 && this.string[i - 1] instanceof Expression && StringUtils.startsWithIgnoreCase((String)o, "s")) {
                b.append(((String)o).substring(1));
            } else {
                b.append(o);
            }
            ++i;
        }
        return b.toString();
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (this.isSimple) {
            return String.valueOf('\"') + this.simple + '\"';
        }
        StringBuilder b = new StringBuilder("\"");
        Object[] objectArray = this.string;
        int n = this.string.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Expression) {
                b.append("%" + ((Expression)o).toString(e, debug) + "%");
            } else {
                b.append(o);
            }
            ++n2;
        }
        b.append('\"');
        return b.toString();
    }

    public String getDefaultVariableName() {
        if (this.isSimple) {
            return this.simple;
        }
        StringBuilder b = new StringBuilder();
        Object[] objectArray = this.string;
        int n = this.string.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Expression) {
                b.append("<" + Skript.getSuperClassInfo(((Expression)o).getReturnType()).getCodeName() + ">");
            } else {
                b.append(o);
            }
            ++n2;
        }
        return b.toString();
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public StringMode getMode() {
        return this.mode;
    }

    public void setMode(StringMode mode) {
        this.mode = mode;
    }
}

