/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.util;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.classes.SerializableConverter;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.util.ConvertedLiteral;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.StringMode;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import ch.njol.util.Validate;
import ch.njol.util.iterator.NonNullIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import org.bukkit.event.Event;

public class SimpleLiteral<T>
implements Literal<T>,
DefaultExpression<T> {
    private static final long serialVersionUID = 8435080459332928709L;
    protected final Class<T> c;
    private final boolean isDefault;
    private final boolean and;
    private UnparsedLiteral source = null;
    protected transient T[] data;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.data.getClass().getComponentType());
        String[][] d = new String[this.data.length][];
        int i = 0;
        while (i < this.data.length) {
            d[i] = Skript.serialize(this.data[i]);
            if (d[i] == null) {
                throw new SkriptAPIException("Parsed class cannot be serialized: " + this.data[i].getClass().getName());
            }
            ++i;
        }
        out.writeObject(d);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        Class c = (Class)in.readObject();
        String[][] d = (String[][])in.readObject();
        this.data = (Object[])Array.newInstance(c, d.length);
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = Skript.deserialize(d[i][0], d[i][1]);
            ++i;
        }
    }

    public SimpleLiteral(T[] data, Class<T> c, boolean and) {
        Validate.notNullOrEmpty(data, "data");
        Validate.notNull(c, "c");
        this.data = data;
        this.c = c;
        this.and = data.length == 1 || and;
        this.isDefault = false;
    }

    public SimpleLiteral(T data, boolean isDefault) {
        Validate.notNull(data, "data");
        this.data = (Object[])Array.newInstance(data.getClass(), 1);
        this.data[0] = data;
        this.c = data.getClass();
        this.and = true;
        this.isDefault = isDefault;
    }

    public SimpleLiteral(T[] data, Class<T> to, boolean and, UnparsedLiteral source) {
        this(data, to, and);
        this.source = source;
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    public T[] getArray() {
        return this.data;
    }

    @Override
    public T[] getArray(Event e) {
        return this.data;
    }

    @Override
    public T[] getAll() {
        return this.data;
    }

    @Override
    public T[] getAll(Event e) {
        return this.data;
    }

    @Override
    public T getSingle() {
        return Utils.random(this.data);
    }

    @Override
    public T getSingle(Event e) {
        return this.getSingle();
    }

    @Override
    public Class<T> getReturnType() {
        return this.c;
    }

    public <R> ConvertedLiteral<T, ? extends R> getConvertedExpression(Class<R> to) {
        if (to.isAssignableFrom(this.c)) {
            return new ConvertedLiteral(this, this.data, to);
        }
        SerializableConverter<T, R> p = Skript.getConverter(this.c, to);
        if (p == null) {
            return null;
        }
        R[] parsedData = Converter.ConverterUtils.convert(this.data, to, p);
        return new ConvertedLiteral(this, parsedData, to);
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (debug) {
            return "[" + Skript.toString(this.data, this.getAnd(), StringMode.DEBUG, false) + "]";
        }
        return Skript.toString(this.data, this.getAnd());
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    @Override
    public boolean isSingle() {
        return !this.getAnd() || this.data.length == 1;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public boolean check(Event e, Checker<? super T> c, Condition cond) {
        return SimpleExpression.check(this.data, c, cond.isNegated(), this.getAnd());
    }

    @Override
    public boolean check(Event e, Checker<? super T> c) {
        return SimpleExpression.check(this.data, c, false, this.getAnd());
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getAnd() {
        return this.and;
    }

    @Override
    public boolean setTime(int time) {
        return false;
    }

    @Override
    public int getTime() {
        return 0;
    }

    @Override
    public NonNullIterator<T> iterator(Event e) {
        return new NonNullIterator<T>(){
            private int i = 0;

            @Override
            protected T getNext() {
                if (this.i == SimpleLiteral.this.data.length) {
                    return null;
                }
                return SimpleLiteral.this.data[this.i++];
            }
        };
    }

    @Override
    public boolean isLoopOf(String s) {
        return false;
    }

    @Override
    public boolean canLoop() {
        return !this.isSingle();
    }

    @Override
    public Expression<?> getSource() {
        return this.source == null ? this : this.source;
    }
}

