/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableStringLiteral;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.SimpleLog;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import ch.njol.util.Validate;
import ch.njol.util.iterator.NonNullIterator;
import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.event.Event;

public class UnparsedLiteral
implements Literal<Object> {
    private static final long serialVersionUID = 6106827630431089311L;
    private final String data;
    public static final Pattern literalSplitPattern = Pattern.compile("\\s*,?\\s+(and|n?or)\\s+|\\s*,\\s*", 2);

    public UnparsedLiteral(String data) {
        Validate.notNullOrEmpty(data, "data");
        this.data = data;
    }

    public String getData() {
        return this.data;
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return Object.class;
    }

    @Override
    public <R> Literal<? extends R> getConvertedExpression(Class<R> to) {
        return this.getConvertedExpression(to, ParseContext.DEFAULT);
    }

    public <R> Literal<? extends R> getConvertedExpression(Class<R> to, ParseContext context) {
        if (to == String.class && context == ParseContext.DEFAULT) {
            return VariableStringLiteral.newInstance(this);
        }
        if (to == Object.class) {
            SimpleLog log = SkriptLogger.startSubLog();
            if (context == ParseContext.DEFAULT) {
                VariableStringLiteral vsl = VariableStringLiteral.newInstance(this);
                if (vsl != null) {
                    return vsl;
                }
                if (log.hasErrors()) {
                    log.printLog();
                    return null;
                }
            }
            for (ClassInfo<?> ci : Skript.getClassInfos()) {
                if (ci.getParser() == null || !ci.getParser().canParse(context)) continue;
                log.clear();
                Literal<?> l = this.convert(ci.getC(), ci.getParser(), context);
                if (l == null) continue;
                log.stop();
                log.printLog();
                return l;
            }
            log.stop();
            return null;
        }
        Parser<R> p = Skript.getParser(to);
        if (p == null || !p.canParse(context)) {
            return null;
        }
        return this.convert(to, p, context);
    }

    private <T> Literal<T> convert(Class<T> to, Parser<?> parser, ParseContext context) {
        Object t;
        assert (parser.canParse(context));
        SimpleLog log = SkriptLogger.startSubLog();
        String last = this.data;
        LogEntry lastError = null;
        Object r = parser.parse(this.data, context);
        if (r != null) {
            log.stop();
            log.printLog();
            return new SimpleLiteral(r, false);
        }
        lastError = log.getFirstError();
        log.clear();
        LinkedList ts = new LinkedList();
        Matcher m = literalSplitPattern.matcher(this.data);
        int end = this.data.length();
        int expectedEnd = -1;
        boolean and = true;
        boolean isAndSet = false;
        while (m.find()) {
            if (expectedEnd == -1) {
                expectedEnd = m.start();
            }
            last = this.data.substring(m.end(), end);
            t = parser.parse(last, context);
            lastError = log.getFirstError();
            if (t != null) {
                if (!m.group().matches("\\s*,\\s*")) {
                    if (isAndSet) {
                        if (and != m.group().toLowerCase().contains("and")) {
                            Skript.warning("list has multiple 'and' or 'or', will default to 'and'");
                            and = true;
                        }
                    } else {
                        and = m.group().toLowerCase().contains("and");
                        isAndSet = true;
                    }
                }
                ts.addFirst(t);
                log.clear();
                end = m.start();
                m.region(0, end);
                continue;
            }
            log.clear();
        }
        if (end == expectedEnd) {
            last = this.data.substring(0, end);
            t = parser.parse(last, context);
            lastError = log.getFirstError();
            log.stop();
            if (t != null) {
                ts.addFirst(t);
                return new SimpleLiteral<Object>(ts.toArray((Object[])Array.newInstance(to, ts.size())), to, and, this);
            }
        }
        log.stop();
        if (lastError != null) {
            SkriptLogger.log(lastError);
        } else {
            Skript.error("'" + last + "' is not " + Utils.a(Skript.getSuperClassInfo(to).getName()));
        }
        return null;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "'" + this.data + "'";
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    @Override
    public Expression<?> getSource() {
        return this;
    }

    private static final SkriptAPIException invalidAccessException() {
        return new SkriptAPIException("UnparsedLiterals must be converted before use");
    }

    @Override
    public boolean getAnd() {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public boolean isSingle() {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public Object[] getAll() {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public Object[] getAll(Event e) {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public Object[] getArray() {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public Object[] getArray(Event e) {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public Object getSingle() {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public Object getSingle(Event e) {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public boolean canLoop() {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public NonNullIterator<Object> iterator(Event e) {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public boolean check(Event e, Checker<? super Object> c) {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public boolean check(Event e, Checker<? super Object> c, Condition cond) {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public boolean setTime(int time) {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public int getTime() {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public boolean isDefault() {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public boolean isLoopOf(String s) {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        throw UnparsedLiteral.invalidAccessException();
    }
}

