/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.data.DefaultChangers;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.Time;
import org.bukkit.World;
import org.bukkit.event.Event;

public class ExprTime
extends PropertyExpression<World, Time> {
    private static final long serialVersionUID = 5470906768109932892L;
    private Expression<World> worlds = null;

    static {
        Skript.registerExpression(ExprTime.class, Time.class, Skript.ExpressionType.PROPERTY, "[the] time [(in|of) %worlds%]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, int isDelayed, SkriptParser.ParseResult parser) {
        this.worlds = vars[0];
        this.setExpr(this.worlds);
        return true;
    }

    protected Time[] get(Event e, World[] source) {
        return this.get(source, new Getter<Time, World>(){

            @Override
            public Time get(World w) {
                return new Time((int)w.getTime());
            }
        });
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return DefaultChangers.timeChanger.acceptChange(mode);
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        DefaultChangers.timeChanger.change((World[])this.worlds.getArray(e), delta, mode);
    }

    @Override
    public Class<Time> getReturnType() {
        return Time.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e == null) {
            return "the time in " + this.worlds.toString(e, debug);
        }
        return Skript.getDebugMessage(this.getAll(e));
    }
}

