/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerGameModeChangeEvent;

public class ExprGameMode
extends PropertyExpression<Player, GameMode> {
    private static final long serialVersionUID = 715080620914863107L;
    private Expression<Player> players;

    static {
        Skript.registerExpression(ExprGameMode.class, GameMode.class, Skript.ExpressionType.PROPERTY, "[the] game[ ]mode of %players%", "%players%'[s] game[ ]mode");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, int isDelayed, SkriptParser.ParseResult parser) {
        this.players = vars[0];
        this.setExpr(this.players);
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the gamemode of " + this.players.toString(e, debug);
    }

    protected GameMode[] get(Event e, Player[] source) {
        if (e instanceof PlayerGameModeChangeEvent && this.getTime() >= 0 && this.players.isDefault() && !Delay.isDelayed(e)) {
            return new GameMode[]{((PlayerGameModeChangeEvent)e).getNewGameMode()};
        }
        return this.get(source, new Converter<Player, GameMode>(){

            @Override
            public GameMode convert(Player p) {
                return p.getGameMode();
            }
        });
    }

    @Override
    public Class<GameMode> getReturnType() {
        return GameMode.class;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return Skript.array(GameMode.class);
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        GameMode m = (GameMode)delta;
        Player[] playerArray = this.players.getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            p.setGameMode(m);
            ++n2;
        }
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, PlayerGameModeChangeEvent.class, this.players);
    }
}

