/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.entity.XpOrbData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Utils;
import java.util.List;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

public class ExprDrops
extends SimpleExpression<ItemStack> {
    private static final long serialVersionUID = 3089011835058396051L;
    private int delay;

    static {
        Skript.registerExpression(ExprDrops.class, ItemStack.class, Skript.ExpressionType.SIMPLE, "[the] drops");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, int isDelayed, SkriptParser.ParseResult parser) {
        if (!Utils.contains(ScriptLoader.currentEvents, EntityDeathEvent.class)) {
            Skript.error("'drops' can only be used in death events", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.delay = isDelayed;
        return true;
    }

    protected ItemStack[] get(Event e) {
        if (!(e instanceof EntityDeathEvent)) {
            return null;
        }
        return ((EntityDeathEvent)e).getDrops().toArray(new ItemStack[0]);
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.delay != -1) {
            Skript.error("Can't change the drops anymore after the event has already passed");
            return null;
        }
        return Skript.array(ItemType[].class, XpOrbData.class);
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        if (!(e instanceof EntityDeathEvent)) {
            return;
        }
        if (delta instanceof XpOrbData) {
            if (mode == Changer.ChangeMode.REMOVE && ((XpOrbData)delta).getInternExperience() == -1) {
                ((EntityDeathEvent)e).setDroppedExp(0);
            } else {
                int xp = ((XpOrbData)delta).getExperience();
                if (mode == Changer.ChangeMode.ADD) {
                    xp += ((EntityDeathEvent)e).getDroppedExp();
                } else if (mode == Changer.ChangeMode.REMOVE) {
                    xp = ((EntityDeathEvent)e).getDroppedExp() - xp;
                }
                ((EntityDeathEvent)e).setDroppedExp(xp < 0 ? 0 : xp);
            }
        } else if (delta != null) {
            List drops = ((EntityDeathEvent)e).getDrops();
            switch (mode) {
                case SET: {
                    drops.clear();
                }
                case ADD: {
                    ItemType[] itemTypeArray = (ItemType[])delta;
                    int n = itemTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ItemType i = itemTypeArray[n2];
                        i.addTo(drops);
                        ++n2;
                    }
                    break;
                }
                case REMOVE: {
                    ItemType[] itemTypeArray = (ItemType[])delta;
                    int n = itemTypeArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        ItemType i = itemTypeArray[n3];
                        i.removeFrom(drops);
                        ++n3;
                    }
                    break;
                }
                case CLEAR: {
                    drops.clear();
                }
            }
        }
    }

    @Override
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e == null) {
            return "the drops";
        }
        return Skript.getDebugMessage(this.getAll(e));
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

