/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.PlayerSlot;
import ch.njol.skript.util.Slot;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ExprArmorSlot
extends PropertyExpression<Player, Slot> {
    private static final long serialVersionUID = 5373470689647573757L;
    private Expression<Player> players;
    private int slot;
    private static final String[] slotNames;

    static {
        Skript.registerExpression(ExprArmorSlot.class, Slot.class, Skript.ExpressionType.PROPERTY, "[the] (boot[s]|shoe[s]) [slot] of %players%", "%player%'[s] (boot[s]|shoe[s])", "[the] leg[ging]s [slot] of %players%", "%player%'[s] leg[ging]s", "[the] chestplate[s] [slot] of %players%", "%player%'[s] chestplate[s]", "[the] helm[et][s] [slot] of %players%", "%player%'[s] helm[et][s]");
        slotNames = new String[]{"boots", "leggings", "chestplate", "helmet"};
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, int isDelayed, SkriptParser.ParseResult parser) {
        this.players = vars[0];
        this.setExpr(this.players);
        this.slot = matchedPattern / 2;
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(slotNames[this.slot]) + " of " + this.players.toString(e, debug);
    }

    protected Slot[] get(Event e, Player[] source) {
        return this.get(source, new Converter<Player, Slot>(){

            @Override
            public Slot convert(final Player p) {
                return new PlayerSlot(p.getInventory()){

                    @Override
                    public ItemStack getItem() {
                        return p.getInventory().getArmorContents()[ExprArmorSlot.this.slot];
                    }

                    @Override
                    public void setItem(ItemStack item) {
                        ItemStack[] armour = p.getInventory().getArmorContents();
                        armour[((ExprArmorSlot)(this).ExprArmorSlot.this).slot] = item;
                        p.getInventory().setArmorContents(armour);
                    }

                    @Override
                    public String toString(Event e, boolean debug) {
                        return String.valueOf(slotNames[ExprArmorSlot.this.slot]) + " of " + p.getName();
                    }
                };
            }
        });
    }

    @Override
    public Class<Slot> getReturnType() {
        return Slot.class;
    }
}

