/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import ch.njol.util.StringUtils;
import java.util.Arrays;
import org.bukkit.entity.Enderman;

public class EndermanData
extends EntityData<Enderman> {
    private static final long serialVersionUID = -6712988549478058004L;
    private ItemType[] hand = null;
    private boolean plural;

    static {
        EntityData.register(EndermanData.class, "enderman", Enderman.class, "enderm(a|e)n [(carrying|holding) %-itemtypes%]");
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.hand = (ItemType[])exprs[0].getAll();
        this.plural = StringUtils.startsWithIgnoreCase(parseResult.expr, "endermen");
        return true;
    }

    @Override
    public void set(Enderman entity) {
        if (this.hand != null) {
            entity.setCarriedMaterial(Utils.random(this.hand).getBlock().getRandom().getData());
        }
    }

    @Override
    public boolean match(final Enderman entity) {
        return this.hand == null || SimpleExpression.check(this.hand, new Checker<ItemType>(){

            @Override
            public boolean check(ItemType t) {
                return t.isOfType(entity.getCarriedMaterial().getItemTypeId(), entity.getCarriedMaterial().getData());
            }
        }, false, false);
    }

    @Override
    public Class<Enderman> getType() {
        return Enderman.class;
    }

    @Override
    public String toString() {
        return "enderman carrying " + Skript.toString(this.hand, false);
    }

    @Override
    public boolean isPlural() {
        return this.plural;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.hand);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndermanData)) {
            return false;
        }
        EndermanData other = (EndermanData)obj;
        return Arrays.equals(this.hand, other.hand);
    }

    @Override
    public String serialize() {
        if (this.hand == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        ItemType[] itemTypeArray = this.hand;
        int n = this.hand.length;
        int n2 = 0;
        while (n2 < n) {
            ItemType h = itemTypeArray[n2];
            String[] s = Skript.serialize(h);
            if (s == null) {
                return null;
            }
            if (b.length() != 0) {
                b.append(",");
            }
            b.append(s[0]);
            b.append(":");
            b.append(s[1].replace(",", ",,").replace(":", "::"));
            ++n2;
        }
        return b.toString();
    }

    @Override
    protected boolean deserialize(String s) {
        if (s.isEmpty()) {
            return true;
        }
        String[] split = s.split("(?<!,),(?!,)");
        this.hand = new ItemType[split.length];
        int i = 0;
        while (i < this.hand.length) {
            String[] t = split[i].split("(?<!:):(?::)");
            if (t.length != 2) {
                return false;
            }
            Object o = Skript.deserialize(t[0], t[1].replace(",,", ",").replace("::", ":"));
            if (o == null || !(o instanceof ItemType)) {
                return false;
            }
            this.hand[i] = (ItemType)o;
            ++i;
        }
        return false;
    }
}

