/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Event;

public class EffToggle
extends Effect {
    private static final long serialVersionUID = 7996026371293820669L;
    private Expression<Block> blocks;
    private int toggle;
    private static final byte[] bitFlags;

    static {
        Skript.registerEffect(EffToggle.class, "(close|turn off|de[-]activate) %blocks%", "(toggle|switch) [[the] state of] %blocks%", "(open|turn on|activate) %blocks%");
        bitFlags = new byte[256];
        EffToggle.bitFlags[Material.DETECTOR_RAIL.getId()] = 8;
        EffToggle.bitFlags[Material.WOODEN_DOOR.getId()] = 4;
        EffToggle.bitFlags[Material.IRON_DOOR_BLOCK.getId()] = 4;
        EffToggle.bitFlags[Material.LEVER.getId()] = 8;
        EffToggle.bitFlags[Material.STONE_PLATE.getId()] = 1;
        EffToggle.bitFlags[Material.WOOD_PLATE.getId()] = 1;
        EffToggle.bitFlags[Material.STONE_BUTTON.getId()] = 8;
        EffToggle.bitFlags[Material.TRAP_DOOR.getId()] = 4;
        EffToggle.bitFlags[Material.FENCE_GATE.getId()] = 4;
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        this.blocks = vars[0];
        this.toggle = matchedPattern - 1;
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "toggle " + this.blocks.toString(e, debug);
    }

    @Override
    protected void execute(Event e) {
        Block[] blockArray = this.blocks.getArray(e);
        int n = blockArray.length;
        int n2 = 0;
        while (n2 < n) {
            Block b = blockArray[n2];
            if (b.getType() != Material.WOODEN_DOOR && b.getType() != Material.IRON_DOOR_BLOCK || (b.getData() & 8) != 8 || (b = b.getRelative(BlockFace.DOWN)).getType() == Material.WOODEN_DOOR || b.getType() == Material.IRON_DOOR_BLOCK) {
                int type = b.getTypeId();
                byte data = b.getData();
                if (this.toggle == -1) {
                    b.setData((byte)(data & ~bitFlags[type]));
                } else if (this.toggle == 0) {
                    b.setData((byte)(data ^ bitFlags[type]));
                } else {
                    b.setData((byte)(data | bitFlags[type]));
                }
            }
            ++n2;
        }
    }
}

