/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Offset;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class EffPush
extends Effect {
    private static final long serialVersionUID = -4749884923811319031L;
    private Expression<Entity> entities;
    private Expression<Offset> directions;
    private Expression<Double> speed = null;

    static {
        Skript.registerEffect(EffPush.class, "(push|thrust) %entities% %offsets% [(at|with) (speed|velocity) %-double%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        this.directions = exprs[1];
        this.speed = exprs[2];
        return true;
    }

    @Override
    protected void execute(Event e) {
        Entity[] ents;
        Double v;
        Offset o = Offset.combine(this.directions.getArray(e));
        if (o == null) {
            return;
        }
        Vector mod = o.toVector();
        Double d = v = this.speed == null ? null : this.speed.getSingle(e);
        if (this.speed != null && v == null) {
            return;
        }
        if (v != null) {
            mod.normalize().multiply(v.doubleValue());
        }
        Entity[] entityArray = ents = this.entities.getArray(e);
        int n = ents.length;
        int n2 = 0;
        while (n2 < n) {
            Entity ent = entityArray[n2];
            ent.setVelocity(ent.getVelocity().add(mod));
            ++n2;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "push " + this.entities.toString(e, debug) + " " + this.directions.toString(e, debug) + (this.speed == null ? "" : " at speed " + this.speed.toString(e, debug));
    }
}

