/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustEvent;

public class EffIgnite
extends Effect {
    private static final long serialVersionUID = -8206560853398783813L;
    private static final int DEFAULT_DURATION = 160;
    private Expression<LivingEntity> entities;
    private boolean fire;
    private Expression<Timespan> duration = null;

    static {
        Skript.registerEffect(EffIgnite.class, "(ignite|set fire to) %livingentities% [for %-timespan%]", "(set|light) %livingentities% on fire [for %-timespan%]", "extinguish %livingentities%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        boolean bl = this.fire = exprs.length > 1;
        if (this.fire) {
            this.duration = exprs[1];
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        if (this.entities.isDefault() && e instanceof EntityCombustEvent && !Delay.isDelayed(e)) {
            ((EntityCombustEvent)e).setCancelled(true);
        }
        if (this.fire) {
            int d = 160;
            if (this.duration != null) {
                Timespan t = this.duration.getSingle(e);
                if (t == null) {
                    return;
                }
                d = t.getTicks();
            }
            LivingEntity[] livingEntityArray = this.entities.getArray(e);
            int n = livingEntityArray.length;
            int n2 = 0;
            while (n2 < n) {
                LivingEntity en = livingEntityArray[n2];
                en.setFireTicks(d);
                ++n2;
            }
        } else {
            LivingEntity[] livingEntityArray = this.entities.getArray(e);
            int n = livingEntityArray.length;
            int n3 = 0;
            while (n3 < n) {
                LivingEntity en = livingEntityArray[n3];
                en.setFireTicks(0);
                ++n3;
            }
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return this.fire ? "set " + this.entities.toString(e, debug) + " on fire" : "extinguish " + this.entities.toString(e, debug);
    }
}

