/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.config;

import ch.njol.skript.Skript;
import ch.njol.skript.config.ConfigReader;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;

public class Config {
    boolean simple = false;
    private String indentation = null;
    private String indentationName = null;
    final String defaultSeparator;
    String separator;
    String line = "";
    int level = 0;
    private final SectionNode main;
    boolean modified = false;
    int errors = 0;
    final boolean allowEmptySections;
    String fileName;
    File file = null;

    public Config(InputStream source, String fileName, boolean simple, boolean allowEmptySections, String defaultSeparator) throws IOException {
        this.fileName = fileName;
        this.simple = simple;
        this.allowEmptySections = allowEmptySections;
        this.defaultSeparator = defaultSeparator;
        this.separator = defaultSeparator;
        if (source.available() == 0) {
            this.main = new SectionNode(this);
            Skript.warning("'" + this.getFileName() + "' is empty");
            return;
        }
        if (Skript.logVeryHigh()) {
            Skript.info("loading '" + fileName + "'");
        }
        ConfigReader r = new ConfigReader(source);
        try {
            this.main = SectionNode.load(this, r);
        }
        finally {
            r.close();
        }
    }

    public Config(File file, boolean simple, boolean allowEmptySections, String defaultSeparator) throws IOException {
        this(new FileInputStream(file), file.getName(), simple, allowEmptySections, defaultSeparator);
        this.file = file;
    }

    public Config(String s, String fileName, boolean simple, boolean allowEmptySections, String defaultSeparator) throws IOException {
        this(new ByteArrayInputStream(s.getBytes("UTF-8")), fileName, simple, allowEmptySections, defaultSeparator);
    }

    void setIndentation(String indent) {
        this.indentation = indent;
        this.indentationName = indent.charAt(0) == ' ' ? "space" : "tab";
    }

    String getIndentation() {
        return this.indentation;
    }

    String getIndentationName() {
        return this.indentationName;
    }

    public SectionNode getMainNode() {
        return this.main;
    }

    public String getFileName() {
        return this.file.getName();
    }

    public synchronized void save() throws IOException {
        if (!this.modified) {
            return;
        }
        this.separator = this.defaultSeparator;
        this.file.createNewFile();
        PrintWriter w = new PrintWriter(new FileWriter(this.file));
        this.main.save(w);
        w.flush();
        w.close();
        this.modified = false;
    }

    public boolean isEnabled() {
        return !this.file.getName().startsWith("-");
    }

    public boolean setEnabled(boolean b) {
        if (this.isEnabled() == b) {
            return false;
        }
        return this.file.renameTo(new File(this.file, b ? this.file.getName().substring(1) : "-" + this.file.getName()));
    }

    public File getFile() {
        return this.file;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getByPath(String path) {
        return this.get(path.split("\\."));
    }

    public String get(String ... path) {
        SectionNode section = this.main;
        int i = 0;
        while (i < path.length) {
            Node n = section.get(path[i]);
            if (n == null) {
                return null;
            }
            if (n instanceof SectionNode) {
                if (i == path.length - 1) {
                    return null;
                }
            } else {
                if (i == path.length - 1) {
                    return ((EntryNode)n).getValue();
                }
                return null;
            }
            section = (SectionNode)n;
            ++i;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.main.isEmpty();
    }
}

