/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes;

import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ParseContext;
import ch.njol.util.Validate;

public class EnumParser<E extends Enum<E>>
extends Parser<E> {
    private final Class<E> c;
    private final String codeType;

    public EnumParser(Class<E> c) {
        Validate.notNull(c, "c");
        this.c = c;
        this.codeType = c.getSimpleName().toLowerCase();
    }

    public EnumParser(Class<E> c, String codeType) {
        Validate.notNull(c, "c");
        this.c = c;
        this.codeType = codeType;
    }

    @Override
    public E parse(String s, ParseContext context) {
        try {
            return Enum.valueOf(this.c, s);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public String toString(E o) {
        return ((Enum)o).toString().toLowerCase().replace('_', ' ');
    }

    @Override
    public String toVariableNameString(E o) {
        return this.codeType == null ? ((Enum)o).toString().toLowerCase().replace('_', ' ') : String.valueOf(this.codeType) + ":" + ((Enum)o).toString().toLowerCase().replace('_', ' ');
    }

    @Override
    public String getVariableNamePattern() {
        return "\\S+";
    }
}

