/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes;

import java.io.Serializable;

public interface Comparator<T1, T2>
extends Serializable {
    public static final Comparator<?, ?> equalsComparator = new Comparator<Object, Object>(){
        private static final long serialVersionUID = -7978700549410981219L;

        @Override
        public Relation compare(Object o1, Object o2) {
            if (o1 == null || o2 == null) {
                return Relation.NOT_EQUAL;
            }
            return Relation.get(o1.equals(o2));
        }

        @Override
        public boolean supportsOrdering() {
            return false;
        }
    };

    public Relation compare(T1 var1, T2 var2);

    public boolean supportsOrdering();

    public static class ComparatorInfo<T1, T2> {
        public Class<T1> c1;
        public Class<T2> c2;
        public Comparator<T1, T2> c;

        public ComparatorInfo(Class<T1> c1, Class<T2> c2, Comparator<T1, T2> c) {
            this.c1 = c1;
            this.c2 = c2;
            this.c = c;
        }

        public Class<?> getType(int i) {
            return i == 0 ? this.c1 : this.c2;
        }
    }

    public static final class Relation
    extends Enum<Relation> {
        public static final /* enum */ Relation EQUAL = new Relation();
        public static final /* enum */ Relation NOT_EQUAL = new Relation();
        public static final /* enum */ Relation GREATER = new Relation();
        public static final /* enum */ Relation GREATER_OR_EQUAL = new Relation();
        public static final /* enum */ Relation SMALLER = new Relation();
        public static final /* enum */ Relation SMALLER_OR_EQUAL = new Relation();
        private static final /* synthetic */ Relation[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Relation[]{EQUAL, NOT_EQUAL, GREATER, GREATER_OR_EQUAL, SMALLER, SMALLER_OR_EQUAL};
        }

        public static Relation get(boolean b) {
            return b ? EQUAL : NOT_EQUAL;
        }

        public static Relation get(int i) {
            return i == 0 ? EQUAL : (i > 0 ? GREATER : SMALLER);
        }

        public static Relation get(double d) {
            return d == 0.0 ? EQUAL : (d > 0.0 ? GREATER : SMALLER);
        }

        public boolean is(Relation other) {
            if (other == this) {
                return true;
            }
            switch (this) {
                case EQUAL: {
                    return other == SMALLER_OR_EQUAL || other == GREATER_OR_EQUAL;
                }
                case NOT_EQUAL: {
                    return other == SMALLER || other == GREATER;
                }
                case GREATER: {
                    return other == GREATER_OR_EQUAL;
                }
                case GREATER_OR_EQUAL: {
                    return other == EQUAL || other == GREATER;
                }
                case SMALLER: {
                    return other == SMALLER_OR_EQUAL;
                }
                case SMALLER_OR_EQUAL: {
                    return other == EQUAL || other == SMALLER;
                }
            }
            assert (false);
            return false;
        }

        public String toString() {
            switch (this) {
                case EQUAL: {
                    return "equal to";
                }
                case NOT_EQUAL: {
                    return "not equal to";
                }
                case GREATER: {
                    return "greater than";
                }
                case GREATER_OR_EQUAL: {
                    return "greater than or equal to";
                }
                case SMALLER: {
                    return "smaller than";
                }
                case SMALLER_OR_EQUAL: {
                    return "smaller than or equal to";
                }
            }
            assert (false);
            return null;
        }

        public Relation getInverse() {
            switch (this) {
                case EQUAL: {
                    return NOT_EQUAL;
                }
                case NOT_EQUAL: {
                    return EQUAL;
                }
                case GREATER: {
                    return SMALLER_OR_EQUAL;
                }
                case GREATER_OR_EQUAL: {
                    return SMALLER;
                }
                case SMALLER: {
                    return GREATER_OR_EQUAL;
                }
                case SMALLER_OR_EQUAL: {
                    return GREATER;
                }
            }
            assert (false);
            return null;
        }

        public Relation getSwitched() {
            switch (this) {
                case GREATER: {
                    return SMALLER;
                }
                case GREATER_OR_EQUAL: {
                    return SMALLER_OR_EQUAL;
                }
                case SMALLER: {
                    return GREATER;
                }
                case SMALLER_OR_EQUAL: {
                    return GREATER_OR_EQUAL;
                }
            }
            return this;
        }

        public boolean isEqualOrInverse() {
            return this == EQUAL || this == NOT_EQUAL;
        }

        public static Relation[] values() {
            Relation[] relationArray = ENUM$VALUES;
            int n = relationArray.length;
            Relation[] relationArray2 = new Relation[n];
            System.arraycopy(ENUM$VALUES, 0, relationArray2, 0, n);
            return relationArray2;
        }

        public static Relation valueOf(String string) {
            return Enum.valueOf(Relation.class, string);
        }
    }
}

