/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Language;
import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.Updater;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.CommandHelp;
import ch.njol.skript.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.util.ChatPaginator;

public class SkriptCommand
implements CommandExecutor {
    private static final CommandHelp skriptCommandHelp = new CommandHelp("<gray>/<gold>skript", "Skript's main command", "cyan").add(new CommandHelp("reload", "Reloads the config, all scripts, everything, or a specific script", "red").add("all", "Reloads all configs and all scripts").add("config", "Reloads the main config").add("aliases", "Reloads the aliases config").add("scripts", "Reloads all scripts").add("<script>", "Reloads a specific script")).add(new CommandHelp("enable", "Enables all scripts or a specific one", "red").add("all", "Enables all scripts").add("<script>", "Enables a specific script")).add(new CommandHelp("disable", "Disables all scripts or a specific one", "red").add("all", "Disables all scripts").add("<script>", "Disables a specific script")).add(new CommandHelp("update", "Check for updates, read the changelog, and download the latest version of Skript", "red").add("check", "Checks for a new version").add("changes", "See what changed in the newest version").add("download", "Download the newest version")).add("help", "Prints this help message");
    private static /* synthetic */ int[] $SWITCH_TABLE$ch$njol$skript$Updater$UpdateState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        block62: {
            block72: {
                block70: {
                    block71: {
                        block68: {
                            block69: {
                                block64: {
                                    block67: {
                                        block66: {
                                            block65: {
                                                if (!SkriptCommand.skriptCommandHelp.test(sender, args)) {
                                                    return true;
                                                }
                                                if (!args[0].equalsIgnoreCase("reload")) break block64;
                                                if (args[1].equalsIgnoreCase("all")) {
                                                    log = SkriptLogger.startSubLog();
                                                    Skript.reload();
                                                    log.stop();
                                                    if (log.hasErrors()) {
                                                        Skript.error(sender, "Error(s) while reloading the config and all scripts:");
                                                        log.printErrors(sender, null);
                                                    } else {
                                                        Skript.info(sender, "Successfully reloaded the config and all scripts");
                                                    }
                                                    return true;
                                                }
                                                if (!args[1].equalsIgnoreCase("scripts")) break block65;
                                                log = SkriptLogger.startSubLog();
                                                Skript.reloadScripts();
                                                log.stop();
                                                if (log.hasErrors()) {
                                                    Skript.error(sender, "Error(s) while reloading all scripts:");
                                                    log.printErrors(sender, null);
                                                } else {
                                                    Skript.info(sender, "Successfully reloaded all scripts");
                                                }
                                                break block62;
                                            }
                                            if (!args[1].equalsIgnoreCase("config")) break block66;
                                            log = SkriptLogger.startSubLog();
                                            Skript.reloadMainConfig();
                                            log.stop();
                                            if (log.hasErrors()) {
                                                Skript.error(sender, "Error(s) while reloading the main config:");
                                                log.printErrors(sender, null);
                                            } else {
                                                Skript.info(sender, "Successfully reloaded the main config");
                                            }
                                            break block62;
                                        }
                                        if (!args[1].equalsIgnoreCase("aliases")) break block67;
                                        log = SkriptLogger.startSubLog();
                                        Skript.reloadAliases();
                                        log.stop();
                                        if (log.hasErrors()) {
                                            Skript.error(sender, "Error(s) while reloading the aliases config:");
                                            log.printErrors(sender, null);
                                        } else {
                                            Skript.info(sender, "Successfully reloaded the aliases config");
                                        }
                                        break block62;
                                    }
                                    f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                                    if (f == null) {
                                        return true;
                                    }
                                    if (f.getName().startsWith("-")) {
                                        Skript.info(sender, "This script is currently disabled. Use <gray>/<gold>skript <cyan>enable <red>" + f.getName().substring(1, f.getName().length() - 3) + "<reset> to enable it.");
                                        return true;
                                    }
                                    ScriptLoader.unloadScript(f);
                                    log = SkriptLogger.startSubLog();
                                    ScriptLoader.loadScripts(Arrays.asList(new File[]{f}));
                                    log.stop();
                                    if (log.hasErrors()) {
                                        Skript.error(sender, "Error(s) while reloading <gold>" + f.getName() + "<red>:");
                                        log.printErrors(sender, null);
                                    } else {
                                        Skript.info(sender, "Successfully reloaded <gold>" + f.getName() + "<reset>!");
                                    }
                                    return true;
                                }
                                if (!args[0].equalsIgnoreCase("enable")) break block68;
                                if (!args[1].equals("all")) break block69;
                                try {
                                    files = SkriptCommand.toggleScripts(true);
                                    log = SkriptLogger.startSubLog();
                                    ScriptLoader.loadScripts(files);
                                    log.stop();
                                    if (log.hasErrors()) {
                                        Skript.error(sender, "Error(s) while loading disabled scripts:");
                                        log.printErrors(sender, null);
                                        break block62;
                                    }
                                    Skript.info(sender, "Successfully loaded & enabled all previously disabled scripts!");
                                }
                                catch (IOException e) {
                                    Skript.error(sender, "Could not enable any scripts (some scripts might however have been renamed already): " + e.getLocalizedMessage());
                                }
                                break block62;
                            }
                            f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                            if (f == null) {
                                return true;
                            }
                            if (!f.getName().startsWith("-")) {
                                Skript.info(sender, "<gold>" + f.getName() + "<reset> is already enabled!");
                                return true;
                            }
                            try {
                                FileUtils.move(f, new File(f.getParentFile(), f.getName().substring(1)), false);
                            }
                            catch (IOException e) {
                                Skript.error(sender, "Could not enable <gold>" + f.getName().substring(1) + "<red>:<reset> " + e.getLocalizedMessage());
                                return true;
                            }
                            f = new File(f.getParentFile(), f.getName().substring(1));
                            log = SkriptLogger.startSubLog();
                            ScriptLoader.loadScripts(Arrays.asList(new File[]{f}));
                            log.stop();
                            if (log.hasErrors()) {
                                Skript.error(sender, "Error(s) while enabling <gold>" + f.getName() + "<red>:");
                                log.printErrors(sender, null);
                            } else {
                                Skript.info(sender, "Successfully enabled <gold>" + f.getName() + "<reset>!");
                            }
                            return true;
                        }
                        if (!args[0].equalsIgnoreCase("disable")) break block70;
                        if (!args[1].equals("all")) break block71;
                        Skript.disableScripts();
                        try {
                            SkriptCommand.toggleScripts(false);
                            Skript.info(sender, "Successfully disabled all scripts!");
                        }
                        catch (IOException e) {
                            Skript.error(sender, "Could not rename all scripts - some scripts will be enabled again when you restart the server:<reset> " + e.getLocalizedMessage());
                        }
                        break block62;
                    }
                    f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                    if (f == null) {
                        return true;
                    }
                    if (f.getName().startsWith("-")) {
                        Skript.info(sender, "<gold>" + f.getName().substring(1) + "<reset> is already disabled!");
                        return true;
                    }
                    ScriptLoader.unloadScript(f);
                    try {
                        FileUtils.move(f, new File(f.getParentFile(), "-" + f.getName()), false);
                    }
                    catch (IOException e) {
                        Skript.error(sender, "Could not rename <gold>" + f.getName() + "<red>, it will be enabled again when you restart the server:<reset> " + e.getLocalizedMessage());
                        return true;
                    }
                    Skript.info(sender, "Successfully disabled <gold>" + f.getName() + "<reset>!");
                    return true;
                }
                if (!args[0].equalsIgnoreCase("update")) break block72;
                updater = Updater.getInstance();
                var6_21 = updater.stateLock;
                synchronized (var6_21) {
                    block63: {
                        block77: {
                            block76: {
                                block75: {
                                    block74: {
                                        block73: {
                                            state = updater.state;
                                            if (!args[1].equals("check")) break block73;
                                            switch (SkriptCommand.$SWITCH_TABLE$ch$njol$skript$Updater$UpdateState()[state.ordinal()]) {
                                                case 1: {
                                                    updater.check(sender, false);
                                                    break;
                                                }
                                                case 2: {
                                                    Skript.info(sender, Language.get("updater.check_in_progress"));
                                                    break;
                                                }
                                                case 3: {
                                                    updater.check(sender, false);
                                                    break;
                                                }
                                                case 4: {
                                                    if (updater.latest == null) {
                                                        Skript.info(sender, Language.get("updater.running_latest_version"));
                                                        break;
                                                    }
                                                    Skript.info(sender, Language.format("updater.update_available", new Object[]{updater.latest.version, Skript.getVersion()}));
                                                    break;
                                                }
                                                case 5: {
                                                    Skript.info(sender, Language.get("updater.download_in_progress"));
                                                    break;
                                                }
                                                case 6: {
                                                    Skript.info(sender, Language.format("updater.download_error", new Object[]{updater.error}));
                                                    break;
                                                }
                                                case 7: {
                                                    Skript.info(sender, Language.get("updater.downloaded"));
                                                }
                                            }
                                            break block62;
                                        }
                                        if (!args[1].equalsIgnoreCase("changes")) ** GOTO lbl229
                                        if (state != Updater.UpdateState.NOT_STARTED && state != Updater.UpdateState.CHECK_IN_PROGRESS && state != Updater.UpdateState.CHECK_ERROR) break block74;
                                        if (state == Updater.UpdateState.CHECK_ERROR) {
                                            Skript.info(sender, Language.format("updater.check_error", new Object[]{updater.error}));
                                        } else {
                                            Skript.info(sender, Language.get("updater." + state.name()));
                                        }
                                        break block62;
                                    }
                                    if (updater.latest != null) break block75;
                                    Skript.info(sender, Language.get("updater.running_latest_version"));
                                    break block62;
                                }
                                if (args.length != 2 || updater.infos.size() == 1) break block76;
                                Skript.info(sender, "There have been " + updater.infos.size() + " updates since your version:");
                                versions = updater.infos.get((int)0).version.toString();
                                i = updater.infos.size() - 1;
                                while (i >= 0) {
                                    versions = String.valueOf(versions) + ", " + updater.infos.get((int)i).version.toString();
                                    --i;
                                }
                                Skript.message(sender, versions);
                                Skript.message(sender, "To show the changelog of a version type <gold>/skript update changes <version><reset>");
                                break block62;
                            }
                            info = null;
                            pageNum = 1;
                            if (updater.infos.size() != 1) break block77;
                            info = updater.latest;
                            if (args.length >= 3 && args[2].matches("\\d+")) {
                                pageNum = Skript.parseInt(args[2]);
                            }
                            ** GOTO lbl223
                        }
                        version = args[2];
                        for (Updater.VersionInfo i : updater.infos) {
                            if (!i.version.toString().equals(version)) continue;
                            info = i;
                            break;
                        }
                        if (info != null) break block63;
                        Skript.error(sender, "No changelog for the version '" + version + "' available");
                        return true;
                    }
                    if (args.length >= 4 && args[3].matches("\\d+")) {
                        pageNum = Skript.parseInt(args[3]);
                    }
lbl223:
                    // 4 sources

                    page = ChatPaginator.paginate((String)info.changelog, (int)pageNum, (int)55, (int)8);
                    Skript.info(sender, "<bold><cyan>" + info.version + "<reset> (" + info.date + ") <grey>[page " + pageNum + " of " + page.getTotalPages() + "]");
                    sender.sendMessage(page.getLines());
                    if (pageNum < page.getTotalPages()) {
                        Skript.message(sender, "  type <gold>/skript update changes " + (updater.infos.size() == 1 ? "" : info.version + " ") + (pageNum + 1) + "<reset> for the next page");
                    }
                    break block62;
lbl229:
                    // 1 sources

                    if (args[1].equalsIgnoreCase("download")) {
                        switch (SkriptCommand.$SWITCH_TABLE$ch$njol$skript$Updater$UpdateState()[state.ordinal()]) {
                            case 1: {
                                updater.check(sender, true);
                                break;
                            }
                            case 2: {
                                Skript.info(sender, Language.get("updater.check_in_progress"));
                                break;
                            }
                            case 3: {
                                updater.check(sender, true);
                                break;
                            }
                            case 4: {
                                if (updater.latest == null) {
                                    Skript.info(sender, Language.get("updater.running_latest_version"));
                                    break;
                                }
                                updater.download(sender);
                                break;
                            }
                            case 5: {
                                Skript.info(sender, Language.get("updater.download_in_progress"));
                                break;
                            }
                            case 7: {
                                Skript.info(sender, Language.get("updater.downloaded"));
                                break;
                            }
                            case 6: {
                                Skript.info(sender, Language.format("updater.download_error", new Object[]{updater.error}));
                            }
                        }
                    }
                }
            }
            if (args[0].equalsIgnoreCase("help")) {
                SkriptCommand.skriptCommandHelp.showHelp(sender);
            }
        }
        return true;
    }

    private static File getScriptFromArgs(CommandSender sender, String[] args, int start) {
        File f;
        StringBuilder b = new StringBuilder();
        int i = 1;
        while (i < args.length) {
            b.append(" " + args[i]);
            ++i;
        }
        String script = b.toString().trim();
        if (!script.endsWith(".sk")) {
            script = String.valueOf(script) + ".sk";
        }
        if (script.startsWith("-")) {
            script = script.substring(1);
        }
        if (!(f = new File(Skript.getInstance().getDataFolder(), "scripts" + File.separator + script)).exists() && !(f = new File(Skript.getInstance().getDataFolder(), "scripts" + File.separator + "-" + script)).exists()) {
            Skript.error(sender, "Can't find the script <grey>'<gold>" + script + "<grey>'<red> in the scripts folder!");
            return null;
        }
        return f;
    }

    private static final Collection<File> toggleScripts(final boolean enable) throws IOException {
        return FileUtils.renameAll(new File(Skript.getInstance().getDataFolder(), "scripts"), new Converter<String, String>(){

            @Override
            public String convert(String name) {
                if (name.startsWith("-") == enable) {
                    return enable ? name.substring(1) : "-" + name;
                }
                return null;
            }
        });
    }

    static /* synthetic */ int[] $SWITCH_TABLE$ch$njol$skript$Updater$UpdateState() {
        if ($SWITCH_TABLE$ch$njol$skript$Updater$UpdateState != null) {
            return $SWITCH_TABLE$ch$njol$skript$Updater$UpdateState;
        }
        int[] nArray = new int[Updater.UpdateState.values().length];
        try {
            nArray[Updater.UpdateState.CHECKED_FOR_UPDATE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Updater.UpdateState.CHECK_ERROR.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Updater.UpdateState.CHECK_IN_PROGRESS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Updater.UpdateState.DOWNLOADED.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Updater.UpdateState.DOWNLOAD_ERROR.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Updater.UpdateState.DOWNLOAD_IN_PROGRESS.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Updater.UpdateState.NOT_STARTED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$ch$njol$skript$Updater$UpdateState = nArray;
        return nArray;
    }
}

