/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Aliases;
import ch.njol.skript.Language;
import ch.njol.skript.ScriptLoader;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptCommand;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.Updater;
import ch.njol.skript.Variables;
import ch.njol.skript.classes.ChainedConverter;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.classes.InverseComparator;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.SerializableConverter;
import ch.njol.skript.classes.SerializableGetter;
import ch.njol.skript.classes.data.BukkitClasses;
import ch.njol.skript.classes.data.BukkitEventValues;
import ch.njol.skript.classes.data.DefaultClasses;
import ch.njol.skript.classes.data.DefaultComparators;
import ch.njol.skript.classes.data.DefaultConverters;
import ch.njol.skript.classes.data.SkriptClasses;
import ch.njol.skript.command.Commands;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.Statement;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.util.VariableString;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.SimpleLog;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.log.Verbosity;
import ch.njol.skript.util.StringMode;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.Version;
import ch.njol.util.Checker;
import ch.njol.util.Validate;
import ch.njol.util.iterator.ArrayIterator;
import ch.njol.util.iterator.CheckedIterator;
import ch.njol.util.iterator.EnumerationIterable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.mcstats.Metrics;

public final class Skript
extends JavaPlugin
implements Listener {
    private static Skript instance = null;
    private static boolean disabled = false;
    private static Version version = null;
    private static Version minecraftVersion = null;
    private static boolean runningCraftBukkit;
    private static boolean runningBukkit1_3;
    private static Variables variables;
    public static final String SCRIPTSFOLDER = "scripts";
    public static final String quotesError = "Invalid use of quotes (\"). If you want to use quotes in \"quoted text\", double them: \"\".";
    public static final double EPSILON = 1.0E-10;
    public static final double EPSILON_MULT = 1.00001;
    public static final int MAXBLOCKID = 255;
    public static final int TARGETBLOCKMAXDISTANCE = 100;
    public static final int NUMBERACCURACY = 2;
    public static final Random random;
    static EventPriority defaultEventPriority;
    static boolean listenerEnabled;
    private static boolean acceptRegistrations;
    private static final Collection<SyntaxElementInfo<? extends Condition>> conditions;
    private static final Collection<SyntaxElementInfo<? extends Effect>> effects;
    private static final Collection<SyntaxElementInfo<? extends Statement>> statements;
    private static final List<ExpressionInfo<?, ?>> expressions;
    private static final int[] expressionTypesStartIndices;
    private static final Collection<SkriptEvent.SkriptEventInfo<?>> events;
    private static List<Converter.ConverterInfo<?, ?>> converters;
    private static ClassInfo<?>[] classInfos;
    private static final List<ClassInfo<?>> tempClassInfos;
    private static final HashMap<Class<?>, ClassInfo<?>> exactClassInfos;
    private static final HashMap<Class<?>, ClassInfo<?>> superClassInfos;
    private static final HashMap<String, ClassInfo<?>> classInfosByCodeName;
    private static final Collection<Comparator.ComparatorInfo<?, ?>> comparators;
    private static final List<EventValueInfo<?, ?>> defaultEventValues;
    private static final List<EventValueInfo<?, ?>> pastEventValues;
    private static final List<EventValueInfo<?, ?>> futureEventValues;
    private static final String EXCEPTION_PREFIX = "##!! ";
    static final String skriptPrefix;

    static {
        variables = null;
        random = new Random();
        defaultEventPriority = EventPriority.NORMAL;
        listenerEnabled = true;
        acceptRegistrations = true;
        conditions = new ArrayList<SyntaxElementInfo<? extends Condition>>(20);
        effects = new ArrayList<SyntaxElementInfo<? extends Effect>>(20);
        statements = new ArrayList<SyntaxElementInfo<? extends Statement>>(40);
        expressions = new ArrayList(30);
        expressionTypesStartIndices = new int[ExpressionType.values().length];
        events = new ArrayList(50);
        converters = new ArrayList(50);
        classInfos = null;
        tempClassInfos = new ArrayList();
        exactClassInfos = new HashMap();
        superClassInfos = new HashMap();
        classInfosByCodeName = new HashMap();
        comparators = new ArrayList();
        defaultEventValues = new ArrayList(30);
        pastEventValues = new ArrayList();
        futureEventValues = new ArrayList();
        skriptPrefix = ChatColor.GRAY + "[" + ChatColor.GOLD + "Skript" + ChatColor.GRAY + "]" + ChatColor.RESET + " ";
    }

    public static Skript getInstance() {
        return instance;
    }

    public Skript() throws IllegalAccessException {
        if (instance != null) {
            throw new IllegalAccessException("Cannot create multiple instances of Skript!");
        }
        instance = this;
    }

    public static Version getVersion() {
        return version;
    }

    public void onEnable() {
        if (disabled) {
            throw new IllegalStateException("Skript may only be reloaded by either Bukkit's '/reload' or Skript's '/skript reload' command");
        }
        Language.loadDefault();
        version = new Version(this.getDescription().getVersion());
        runningCraftBukkit = Bukkit.getServer().getClass().getName().equals("org.bukkit.craftbukkit.CraftServer");
        String bukkitV = Bukkit.getServer().getBukkitVersion();
        Matcher m = Pattern.compile("\\d+\\.\\d+(\\.\\d+)?").matcher(bukkitV);
        m.find();
        minecraftVersion = new Version(m.group());
        runningBukkit1_3 = minecraftVersion.compareTo(new Version(1, 3)) >= 0;
        this.getCommand("skript").setExecutor((CommandExecutor)new SkriptCommand());
        new DefaultClasses();
        new BukkitClasses();
        new BukkitEventValues();
        new SkriptClasses();
        new DefaultComparators();
        new DefaultConverters();
        try {
            Skript.loadClasses("ch.njol.skript", "conditions", "effects", "events", "expressions", "entity");
        }
        catch (Exception e) {
            Skript.exception(e, "could not load required .class files: " + e.getLocalizedMessage());
            this.setEnabled(false);
            return;
        }
        if (!this.getDataFolder().isDirectory()) {
            this.getDataFolder().mkdirs();
        }
        SkriptConfig.load();
        if (SkriptConfig.checkForNewVersion) {
            Updater.getInstance().check(null, SkriptConfig.automaticallyDownloadNewVersion);
        }
        Aliases.load();
        Commands.registerListener();
        if (Skript.logNormal()) {
            Skript.info(" ~ created by & \u00a9 Peter G\u00fcttinger aka Njol ~");
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                Skript.stopAcceptingRegistrations();
                Skript.variables = new Variables();
                SimpleLog log = SkriptLogger.startSubLog();
                if (!variables.loadVariables()) {
                    log.stop();
                    Skript.logEx();
                    Skript.logEx(new String[]{"===!!!=== Skript variable load error ===!!!==="});
                    Skript.logEx(new String[]{"Unable to load variables" + (log.size() == 0 ? "!" : ":")});
                    for (LogEntry e : log.getLog()) {
                        Skript.logEx(new String[]{e.getMessage()});
                    }
                    Skript.logEx();
                    Skript.logEx(new String[]{"Skript will work properly, but old variables will not be available at all and new ones will not be saved until Skript is able to create a backup of the old file!"});
                    Skript.logEx();
                } else {
                    log.printLog();
                }
                ScriptLoader.loadScripts();
                Skript.info("Skript finished loading!");
                try {
                    Metrics m = new Metrics((Plugin)Skript.this);
                    m.start();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        if (Bukkit.getOnlineMode()) {
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler
                public void onJoin(PlayerJoinEvent e) {
                    if (e.getPlayer().getName().equalsIgnoreCase("Njol")) {
                        Skript.info((CommandSender)e.getPlayer(), "This server is running Skript " + Skript.this.getDescription().getVersion() + " =3");
                    }
                }
            }, (Plugin)this);
        }
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onJoin(final PlayerJoinEvent e) {
                if (e.getPlayer().hasPermission("skript.admin")) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.this, new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Updater updater = Updater.getInstance();
                            Object object = updater.stateLock;
                            synchronized (object) {
                                if ((updater.state == Updater.UpdateState.CHECKED_FOR_UPDATE || updater.state == Updater.UpdateState.DOWNLOAD_ERROR) && updater.latest != null) {
                                    Skript.info((CommandSender)e.getPlayer(), Language.format("updater.update_available", updater.latest.version, version));
                                }
                            }
                        }
                    });
                }
            }
        }, (Plugin)this);
    }

    public static Version getMinecraftVersion() {
        return minecraftVersion;
    }

    public static boolean isRunningCraftBukkit() {
        return runningCraftBukkit;
    }

    public static boolean isRunningBukkit1_3() {
        return runningBukkit1_3;
    }

    public static Variables getVariables() {
        return variables;
    }

    static final void disableScripts() {
        for (Trigger t : ScriptLoader.selfRegisteredTriggers) {
            ((SelfRegisteringSkriptEvent)t.getEvent()).unregisterAll();
        }
        ScriptLoader.selfRegisteredTriggers.clear();
        VariableString.variableNames.clear();
        SkriptEventHandler.triggers.clear();
        Commands.clearCommands();
    }

    static final void reload() {
        Skript.disableScripts();
        Skript.reloadMainConfig();
        Skript.reloadAliases();
        ScriptLoader.loadScripts();
    }

    static final void reloadScripts() {
        Skript.disableScripts();
        ScriptLoader.loadScripts();
    }

    static final void reloadMainConfig() {
        SkriptConfig.load();
    }

    static final void reloadAliases() {
        Aliases.clear();
        Aliases.load();
    }

    public void onDisable() {
        if (disabled) {
            return;
        }
        disabled = true;
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        variables.saveVariables(true);
        Skript.disableScripts();
        new Thread(new Runnable(){

            @Override
            public void run() {
                block14: {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        Field modifiers = Field.class.getDeclaredField("modifiers");
                        modifiers.setAccessible(true);
                        JarFile jar = new JarFile(Skript.this.getFile());
                        try {
                            for (JarEntry e : new EnumerationIterable<JarEntry>(jar.entries())) {
                                if (!e.getName().endsWith(".class")) continue;
                                try {
                                    Class<?> c = Class.forName(e.getName().replace('/', '.').substring(0, e.getName().length() - ".class".length()), false, Skript.this.getClassLoader());
                                    Field[] fieldArray = c.getDeclaredFields();
                                    int n = fieldArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Field f = fieldArray[n2];
                                        if (Modifier.isStatic(f.getModifiers()) && !f.getType().isPrimitive()) {
                                            if (Modifier.isFinal(f.getModifiers())) {
                                                modifiers.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                                            }
                                            f.setAccessible(true);
                                            f.set(null, null);
                                        }
                                        ++n2;
                                    }
                                }
                                catch (Throwable ex) {
                                    if (!$assertionsDisabled && !(ex instanceof NoClassDefFoundError)) {
                                        throw new AssertionError();
                                    }
                                }
                            }
                        }
                        finally {
                            jar.close();
                        }
                    }
                    catch (Throwable ex) {
                        if ($assertionsDisabled) break block14;
                        throw new AssertionError();
                    }
                }
            }
        }).start();
    }

    private static void loadClasses(String packageName, String ... subPackages) throws IOException {
        JarFile jar = new JarFile(Skript.getInstance().getFile());
        int i = 0;
        while (i < subPackages.length) {
            subPackages[i] = String.valueOf(subPackages[i].replace('.', '/')) + "/";
            ++i;
        }
        try {
            String packageWithSlashes = String.valueOf(packageName.replace('.', '/')) + "/";
            block6: for (JarEntry e : new EnumerationIterable<JarEntry>(jar.entries())) {
                if (!e.getName().startsWith(packageWithSlashes) || !e.getName().endsWith(".class")) continue;
                String[] stringArray = subPackages;
                int n = subPackages.length;
                int n2 = 0;
                while (n2 < n) {
                    String sub = stringArray[n2];
                    if (e.getName().startsWith(sub, packageWithSlashes.length()) && e.getName().lastIndexOf(47) == packageWithSlashes.length() + sub.length() - 1) {
                        String c = e.getName().replace('/', '.').substring(0, e.getName().length() - ".class".length());
                        try {
                            Class.forName(c);
                        }
                        catch (ClassNotFoundException ex) {
                            Skript.exception(ex, "cannot load class " + c);
                        }
                        continue block6;
                    }
                    ++n2;
                }
            }
        }
        finally {
            jar.close();
        }
    }

    public static void outdatedError() {
        Skript.error("Skript v" + instance.getDescription().getVersion() + " is not fully compatible with Bukkit " + Bukkit.getVersion() + ". Some feature(s) will be broken until you update Skript.");
    }

    public static void outdatedError(Exception e) {
        Skript.outdatedError();
        e.printStackTrace();
    }

    public static EventPriority getDefaultEventPriority() {
        return defaultEventPriority;
    }

    public static <T> T[] array(T ... array) {
        return array;
    }

    public static final int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return s.startsWith("-") ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }
    }

    public static void disableListener() {
        listenerEnabled = false;
    }

    public static void enableListener() {
        listenerEnabled = true;
    }

    private static void checkAcceptRegistrations() {
        if (!acceptRegistrations) {
            throw new SkriptAPIException("Registering is disabled after initialization!");
        }
    }

    private static void stopAcceptingRegistrations() {
        acceptRegistrations = false;
        Skript.createMissingConverters();
        Skript.sortClassInfos();
        if (Skript.debug()) {
            StringBuilder b = new StringBuilder();
            ClassInfo<?>[] classInfoArray = classInfos;
            int n = classInfos.length;
            int n2 = 0;
            while (n2 < n) {
                ClassInfo<?> ci = classInfoArray[n2];
                if (b.length() != 0) {
                    b.append(", ");
                }
                b.append(ci.getCodeName());
                ++n2;
            }
            Skript.info("All registered classes in order: " + b.toString());
        }
    }

    public static <E extends Condition> void registerCondition(Class<E> condition, String ... patterns) throws IllegalArgumentException {
        Skript.checkAcceptRegistrations();
        SyntaxElementInfo<E> info = new SyntaxElementInfo<E>(patterns, condition);
        conditions.add(info);
        statements.add(info);
    }

    public static <E extends Effect> void registerEffect(Class<E> effect, String ... patterns) throws IllegalArgumentException {
        Skript.checkAcceptRegistrations();
        SyntaxElementInfo<E> info = new SyntaxElementInfo<E>(patterns, effect);
        effects.add(info);
        statements.add(info);
    }

    public static Collection<SyntaxElementInfo<? extends Statement>> getStatements() {
        return statements;
    }

    public static Collection<SyntaxElementInfo<? extends Condition>> getConditions() {
        return conditions;
    }

    public static Collection<SyntaxElementInfo<? extends Effect>> getEffects() {
        return effects;
    }

    public static <E extends Expression<T>, T> void registerExpression(Class<E> c, Class<T> returnType, ExpressionType type, String ... patterns) throws IllegalArgumentException {
        Skript.checkAcceptRegistrations();
        ExpressionInfo<E, T> info = new ExpressionInfo<E, T>(patterns, returnType, c);
        int i = type.ordinal() + 1;
        while (i < ExpressionType.values().length) {
            int n = i++;
            expressionTypesStartIndices[n] = expressionTypesStartIndices[n] + 1;
        }
        expressions.add(expressionTypesStartIndices[type.ordinal()], info);
    }

    public static Iterator<ExpressionInfo<?, ?>> getExpressions() {
        return expressions.iterator();
    }

    public static Iterator<ExpressionInfo<?, ?>> getExpressions(final Class<?> returnType) {
        return new CheckedIterator(expressions.iterator(), new Checker<ExpressionInfo<?, ?>>(){

            @Override
            public boolean check(ExpressionInfo<?, ?> i) {
                return Skript.converterExists(i.returnType, returnType);
            }
        });
    }

    public static <E extends SkriptEvent> void registerEvent(Class<E> c, Class<? extends Event> event, String ... patterns) throws IllegalArgumentException {
        Skript.checkAcceptRegistrations();
        events.add(new SkriptEvent.SkriptEventInfo<E>(patterns, c, Skript.array(event)));
    }

    public static <E extends SkriptEvent> void registerEvent(Class<E> c, Class<? extends Event>[] events, String ... patterns) throws IllegalArgumentException {
        Skript.checkAcceptRegistrations();
        Skript.events.add(new SkriptEvent.SkriptEventInfo<E>(patterns, c, events));
    }

    public static final Collection<SkriptEvent.SkriptEventInfo<?>> getEvents() {
        return events;
    }

    public static <F, T> void registerConverter(Class<F> from, Class<T> to, SerializableConverter<F, T> converter) {
        Skript.registerConverter(from, to, converter, 0);
    }

    public static <F, T> void registerConverter(Class<F> from, Class<T> to, SerializableConverter<F, T> converter, int options) {
        Skript.checkAcceptRegistrations();
        converters.add(new Converter.ConverterInfo<F, T>(from, to, converter, options));
    }

    private static void createMissingConverters() {
        int i = 0;
        while (i < converters.size()) {
            Converter.ConverterInfo<?, ?> info = converters.get(i);
            int j = 0;
            while (j < converters.size()) {
                Converter.ConverterInfo<?, ?> info2 = converters.get(j);
                if ((info.options & 2) == 0 && (info2.options & 1) == 0 && info2.from.isAssignableFrom(info.to) && !Skript.converterExists(info.from, info2.to)) {
                    converters.add(Skript.createChainedConverter(info, info2));
                } else if ((info.options & 1) == 0 && (info2.options & 2) == 0 && info.from.isAssignableFrom(info2.to) && !Skript.converterExists(info2.from, info.to)) {
                    converters.add(Skript.createChainedConverter(info2, info));
                }
                ++j;
            }
            ++i;
        }
    }

    private static <F, M, T> Converter.ConverterInfo<F, T> createChainedConverter(Converter.ConverterInfo<?, ?> first, Converter.ConverterInfo<?, ?> second) {
        return new Converter.ConverterInfo(first.from, second.to, new ChainedConverter(first.converter, second.converter), first.options | second.options);
    }

    public static <F, T> T convert(F o, Class<T> to) {
        Validate.notNull(to, "to");
        if (o == null) {
            return null;
        }
        if (to.isInstance(o)) {
            return (T)o;
        }
        SerializableConverter<?, T> conv = Skript.getConverter(o.getClass(), to);
        if (conv == null) {
            return null;
        }
        return conv.convert(o);
    }

    public static <T> T[] convertArray(Object[] o, Class<T> to) {
        Validate.notNull(to, "to");
        if (o == null) {
            return null;
        }
        if (to.isAssignableFrom(o.getClass().getComponentType())) {
            return o;
        }
        ArrayList<T> l = new ArrayList<T>(o.length);
        Object[] objectArray = o;
        int n = o.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            T c = Skript.convert(e, to);
            if (c != null) {
                l.add(c);
            }
            ++n2;
        }
        return l.toArray((Object[])Array.newInstance(to, l.size()));
    }

    public static final boolean converterExists(Class<?> from, Class<?> to) {
        Validate.notNull(from, to);
        if (to.isAssignableFrom(from) || from.isAssignableFrom(to)) {
            return true;
        }
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (!conv.from.isAssignableFrom(from) && !from.isAssignableFrom(conv.from) || !conv.to.isAssignableFrom(to) && !to.isAssignableFrom(conv.to)) continue;
            return true;
        }
        return false;
    }

    public static final <F, T> SerializableConverter<? super F, ? extends T> getConverter(Class<F> from, Class<T> to) {
        Validate.notNull(from, to);
        Converter.ConverterInfo<F, T> ci = Skript.getConverterInfo(from, to);
        if (ci != null) {
            return ci.converter;
        }
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (conv.from.isAssignableFrom(from) && conv.to.isAssignableFrom(to)) {
                return Converter.ConverterUtils.createInstanceofConverter(conv.converter, to);
            }
            if (!from.isAssignableFrom(conv.from) || !to.isAssignableFrom(conv.to)) continue;
            return Converter.ConverterUtils.createInstanceofConverter(conv);
        }
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (!from.isAssignableFrom(conv.from) || !conv.to.isAssignableFrom(to)) continue;
            return Converter.ConverterUtils.createDoubleInstanceofConverter(conv, to);
        }
        return null;
    }

    private static final <F, T> Converter.ConverterInfo<? super F, ? extends T> getConverterInfo(Class<F> from, Class<T> to) {
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (!conv.from.isAssignableFrom(from) || !to.isAssignableFrom(conv.to)) continue;
            return conv;
        }
        return null;
    }

    public static <T> void registerClass(ClassInfo<T> info) {
        Skript.checkAcceptRegistrations();
        if (classInfosByCodeName.containsKey(info.getCodeName())) {
            throw new IllegalArgumentException("Can't register " + info.getC().getName() + " with the code name " + info.getCodeName() + " because that name is already used by " + classInfosByCodeName.get(info.getCodeName()));
        }
        if (exactClassInfos.containsKey(info.getC())) {
            throw new IllegalArgumentException("Can't register the class info " + info.getCodeName() + " because the class " + info.getC().getName() + " is already registered");
        }
        exactClassInfos.put(info.getC(), info);
        classInfosByCodeName.put(info.getCodeName(), info);
        tempClassInfos.add(info);
    }

    /*
     * WARNING - void declaration
     */
    private static final void sortClassInfos() {
        assert (classInfos == null);
        LinkedList classInfos = new LinkedList();
        block0: for (ClassInfo<?> ci : tempClassInfos) {
            if (ci.after() == null || ci.after().isEmpty()) continue;
            for (ClassInfo<?> ci2 : tempClassInfos) {
                if (!ci.after().contains(ci2.getCodeName())) continue;
                ci2.before().add(ci.getCodeName());
                ci.after().remove(ci2.getCodeName());
                if (ci.after().isEmpty()) continue block0;
            }
        }
        for (ClassInfo<?> ci : tempClassInfos) {
            for (ClassInfo<?> ci2 : tempClassInfos) {
                if (ci == ci2 || !ci2.getC().isAssignableFrom(ci.getC())) continue;
                ci.before().add(ci2.getCodeName());
            }
        }
        boolean changed = true;
        while (changed) {
            void var2_4;
            changed = false;
            boolean bl = false;
            while (var2_4 < tempClassInfos.size()) {
                ClassInfo<?> ci = tempClassInfos.get((int)var2_4);
                if (ci.before().isEmpty()) {
                    classInfos.addFirst(ci);
                    tempClassInfos.remove((int)var2_4);
                    --var2_4;
                    for (ClassInfo<?> ci2 : tempClassInfos) {
                        ci2.before().remove(ci.getCodeName());
                    }
                    changed = true;
                }
                ++var2_4;
            }
        }
        Skript.classInfos = classInfos.toArray(new ClassInfo[classInfos.size()]);
        if (!tempClassInfos.isEmpty()) {
            throw new IllegalStateException("ClassInfos with circular dependencies detected: " + tempClassInfos);
        }
        if (Skript.debug()) {
            for (ClassInfo classInfo : classInfos) {
                if ((classInfo.before() == null || classInfo.before().isEmpty()) && (classInfo.after() == null || classInfo.after().isEmpty())) continue;
                HashSet<String> s = new HashSet<String>();
                if (classInfo.before() != null) {
                    s.addAll(classInfo.before());
                }
                if (classInfo.after() != null) {
                    s.addAll(classInfo.after());
                }
                Skript.info(String.valueOf(s.size()) + " dependency/ies could not be resolved for " + classInfo + ": " + s);
            }
        }
    }

    private static final void checkAllowClassInfoInteraction() {
        if (acceptRegistrations) {
            throw new IllegalStateException("Cannot use classinfos until registration is over");
        }
    }

    public static Iterable<ClassInfo<?>> getClassInfos() {
        Skript.checkAllowClassInfoInteraction();
        return new Iterable<ClassInfo<?>>(){

            @Override
            public Iterator<ClassInfo<?>> iterator() {
                return new ArrayIterator(classInfos);
            }
        };
    }

    public static ClassInfo<?> getClassInfo(String codeName) {
        Skript.checkAllowClassInfoInteraction();
        ClassInfo<?> ci = classInfosByCodeName.get(codeName);
        if (ci == null) {
            throw new SkriptAPIException("no class info found for " + codeName);
        }
        return ci;
    }

    public static ClassInfo<?> getClassInfoNoError(String codeName) {
        Skript.checkAllowClassInfoInteraction();
        return classInfosByCodeName.get(codeName);
    }

    public static <T> ClassInfo<T> getExactClassInfo(Class<T> c) {
        Skript.checkAllowClassInfoInteraction();
        return exactClassInfos.get(c);
    }

    public static <T> ClassInfo<? super T> getSuperClassInfo(Class<T> c) {
        Skript.checkAllowClassInfoInteraction();
        ClassInfo<?> i = superClassInfos.get(c);
        if (i != null) {
            return i;
        }
        ClassInfo<?>[] classInfoArray = classInfos;
        int n = classInfos.length;
        int n2 = 0;
        while (n2 < n) {
            ClassInfo<?> ci = classInfoArray[n2];
            if (ci.getC().isAssignableFrom(c)) {
                if (!acceptRegistrations) {
                    superClassInfos.put(c, ci);
                }
                return ci;
            }
            ++n2;
        }
        return null;
    }

    public static Class<?> getClass(String codeName) {
        Skript.checkAllowClassInfoInteraction();
        return Skript.getClassInfo(codeName).getC();
    }

    public static ClassInfo<?> getClassInfoFromUserInput(String name) {
        Skript.checkAllowClassInfoInteraction();
        name = name.toLowerCase();
        ClassInfo<?>[] classInfoArray = classInfos;
        int n = classInfos.length;
        int n2 = 0;
        while (n2 < n) {
            ClassInfo<?> ci = classInfoArray[n2];
            if (ci.getUserInputPatterns() != null) {
                Pattern[] patternArray = ci.getUserInputPatterns();
                int n3 = patternArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Pattern pattern = patternArray[n4];
                    if (pattern.matcher(name).matches()) {
                        return ci;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    public static Class<?> getClassFromUserInput(String name) {
        Skript.checkAllowClassInfoInteraction();
        ClassInfo<?> ci = Skript.getClassInfoFromUserInput(name);
        return ci == null ? null : ci.getC();
    }

    public static Class<?> getClassByName(String name) {
        Skript.checkAllowClassInfoInteraction();
        ClassInfo<?>[] classInfoArray = classInfos;
        int n = classInfos.length;
        int n2 = 0;
        while (n2 < n) {
            ClassInfo<?> ci = classInfoArray[n2];
            if (ci.getName().equalsIgnoreCase(name)) {
                return ci.getC();
            }
            ++n2;
        }
        return null;
    }

    public static DefaultExpression<?> getDefaultExpression(String codeName) {
        Skript.checkAllowClassInfoInteraction();
        return Skript.getClassInfo(codeName).getDefaultExpression();
    }

    public static <T> DefaultExpression<T> getDefaultExpression(Class<T> c) {
        Skript.checkAllowClassInfoInteraction();
        ClassInfo<?> ci = exactClassInfos.get(c);
        return ci == null ? null : ci.getDefaultExpression();
    }

    public static final String getExactClassName(Class<?> c) {
        Skript.checkAllowClassInfoInteraction();
        ClassInfo<?> ci = exactClassInfos.get(c);
        return ci == null ? null : ci.getCodeName();
    }

    public static <T> T parseSimple(String s, Class<T> c, ParseContext context) {
        SimpleLog log = SkriptLogger.startSubLog();
        ClassInfo<?>[] classInfoArray = classInfos;
        int n = classInfos.length;
        int n2 = 0;
        while (n2 < n) {
            ClassInfo<?> info = classInfoArray[n2];
            if (info.getParser() != null && c.isAssignableFrom(info.getC())) {
                log.clear();
                Object t = info.getParser().parse(s, context);
                if (t != null) {
                    SkriptLogger.stopSubLog(log);
                    log.printLog();
                    return (T)t;
                }
            }
            ++n2;
        }
        SkriptLogger.stopSubLog(log);
        return null;
    }

    public static <T> T parse(String s, Class<T> c, ParseContext context) {
        Object t = Skript.parseSimple(s, c, context);
        if (t != null) {
            return t;
        }
        SimpleLog log = SkriptLogger.startSubLog();
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (!c.isAssignableFrom(conv.to)) continue;
            log.clear();
            Object o = Skript.parseSimple(s, conv.from, context);
            if (o == null || (t = Converter.ConverterUtils.convert(conv, o)) == null) continue;
            SkriptLogger.stopSubLog(log);
            log.printLog();
            return t;
        }
        SkriptLogger.stopSubLog(log);
        return null;
    }

    public static final <T> Parser<? extends T> getParser(Class<T> to) {
        Skript.checkAllowClassInfoInteraction();
        int i = classInfos.length - 1;
        while (i >= 0) {
            ClassInfo<?> ci = classInfos[i];
            if (to.isAssignableFrom(ci.getC()) && ci.getParser() != null) {
                return ci.getParser();
            }
            --i;
        }
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (!to.isAssignableFrom(conv.to)) continue;
            int i2 = classInfos.length - 1;
            while (i2 >= 0) {
                ClassInfo<?> ci = classInfos[i2];
                if (conv.from.isAssignableFrom(ci.getC()) && ci.getParser() != null) {
                    return Skript.createConvertedParser(ci.getParser(), conv.converter);
                }
                --i2;
            }
        }
        return null;
    }

    public static final <T> Parser<? extends T> getExactParser(Class<T> c) {
        if (acceptRegistrations) {
            for (ClassInfo<?> ci : tempClassInfos) {
                if (ci.getC() != c) continue;
                return ci.getParser();
            }
            return null;
        }
        ClassInfo<T> ci = Skript.getExactClassInfo(c);
        return ci == null ? null : ci.getParser();
    }

    private static final <F, T> Parser<T> createConvertedParser(final Parser<?> parser, final Converter<F, T> converter) {
        return new Parser<T>(){

            @Override
            public T parse(String s, ParseContext context) {
                Object f = parser.parse(s, context);
                if (f == null) {
                    return null;
                }
                return converter.convert(f);
            }

            @Override
            public String toString(T o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String toVariableNameString(T o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getVariableNamePattern() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static String toString(Object o) {
        return Skript.toString(o, StringMode.MESSAGE, false);
    }

    public static String getDebugMessage(Object o) {
        return Skript.toString(o, StringMode.DEBUG, false);
    }

    public static final String toString(Object[] os, boolean and) {
        return Skript.toString(os, and, StringMode.MESSAGE, false);
    }

    public static final <T> String toString(T o, StringMode mode, boolean plural) {
        boolean code;
        boolean bl = code = mode == StringMode.VARIABLE_NAME;
        if (o == null) {
            return "<none>";
        }
        if (o.getClass().isArray()) {
            if (((Object[])o).length == 0) {
                return "<none>";
            }
            StringBuilder b = new StringBuilder();
            boolean first = true;
            Object[] objectArray = (Object[])o;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object i = objectArray[n2];
                if (!first) {
                    b.append(", ");
                }
                b.append(Skript.toString(i, mode, plural));
                first = false;
                ++n2;
            }
            return "[" + b.toString() + "]";
        }
        ClassInfo<?>[] classInfoArray = classInfos;
        int n = classInfos.length;
        int n3 = 0;
        while (n3 < n) {
            ClassInfo<?> ci = classInfoArray[n3];
            if (ci.getParser() != null && ci.getC().isAssignableFrom(o.getClass())) {
                String s;
                String string = s = code ? ci.getParser().toVariableNameString(o) : Utils.toPlural(ci.getParser().toString(o, mode), plural);
                if (s != null) {
                    return s;
                }
            }
            ++n3;
        }
        return code ? "object:" + o : String.valueOf(o);
    }

    public static final String toString(Object[] os, boolean and, StringMode mode, boolean plural) {
        if (os.length == 0) {
            return Skript.toString(null);
        }
        if (os.length == 1) {
            return Skript.toString(os[0], mode, plural);
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < os.length) {
            if (i != 0) {
                if (i == os.length - 1) {
                    b.append(and ? " and " : " or ");
                } else {
                    b.append(", ");
                }
            }
            b.append(Skript.toString(os[i], mode, plural));
            ++i;
        }
        return b.toString();
    }

    public static final String[] serialize(Object o) {
        ClassInfo<?> ci = Skript.getSuperClassInfo(o.getClass());
        if (ci == null) {
            return null;
        }
        if (ci.getSerializeAs() != null) {
            ClassInfo<?> as = Skript.getExactClassInfo(ci.getSerializeAs());
            if (as == null || as.getSerializer() == null) {
                throw new SkriptAPIException(String.valueOf(ci.getSerializeAs().getName()) + ", the class to serialize " + o.getClass().getName() + " as, is not registered or not serializable");
            }
            Object s = Skript.convert(o, as.getC());
            if (s == null) {
                return null;
            }
            return new String[]{as.getCodeName(), as.getSerializer().serialize(s)};
        }
        if (ci.getSerializer() != null) {
            return new String[]{ci.getCodeName(), ci.getSerializer().serialize(o)};
        }
        return null;
    }

    public static final Object deserialize(String type, String value) {
        ClassInfo<?> ci = Skript.getClassInfo(type);
        if (ci == null || ci.getSerializer() == null) {
            return null;
        }
        return ci.getSerializer().deserialize(value);
    }

    public static <T1, T2> void registerComparator(Class<T1> t1, Class<T2> t2, Comparator<T1, T2> c) {
        Skript.checkAcceptRegistrations();
        if (t1 == Object.class || t2 == Object.class) {
            throw new IllegalArgumentException("must not add a comparator for Object");
        }
        comparators.add(new Comparator.ComparatorInfo<T1, T2>(t1, t2, c));
    }

    public static final Collection<Comparator.ComparatorInfo<?, ?>> getComparators() {
        return comparators;
    }

    public static <T1, T2> Comparator.Relation compare(T1 t1, T2 t2) {
        for (Comparator.ComparatorInfo<?, ?> info : comparators) {
            if (info.c1.isInstance(t1) && info.c2.isInstance(t2)) {
                return info.c.compare(t1, t2);
            }
            if (!info.c1.isInstance(t2) || !info.c2.isInstance(t1)) continue;
            return info.c.compare(t2, t1);
        }
        if (t1 != null && t1.getClass().isInstance(t2)) {
            return Comparator.Relation.get(t1.equals(t2));
        }
        if (t2 != null && t2.getClass().isInstance(t1)) {
            return Comparator.Relation.get(t2.equals(t1));
        }
        return null;
    }

    public static <T1, T2> Comparator<T1, T2> getComparator(Class<T1> c1, Class<T2> c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        for (Comparator.ComparatorInfo<?, ?> c : comparators) {
            if (c.c1.isAssignableFrom(c1) && c.c2.isAssignableFrom(c2)) {
                return c.c;
            }
            if (!c.c1.isAssignableFrom(c2) || !c.c2.isAssignableFrom(c1)) continue;
            return new InverseComparator(c.c);
        }
        return null;
    }

    private static final List<EventValueInfo<?, ?>> getEventValuesList(int time) {
        if (time == -1) {
            return pastEventValues;
        }
        if (time == 0) {
            return defaultEventValues;
        }
        if (time == 1) {
            return futureEventValues;
        }
        throw new IllegalArgumentException("time must be -1, 0, or 1");
    }

    public static <T, E extends Event> void registerEventValue(Class<E> e, Class<T> c, SerializableGetter<T, E> g, int time) {
        Skript.registerEventValue(e, c, g, time, null, null);
    }

    public static <T, E extends Event> void registerEventValue(Class<E> e, Class<T> c, SerializableGetter<T, E> g, int time, String excludeErrorMessage, Class<? extends E> ... excludes) {
        Skript.checkAcceptRegistrations();
        List<EventValueInfo<?, ?>> eventValues = Skript.getEventValuesList(time);
        int i = 0;
        while (i < eventValues.size()) {
            EventValueInfo<?, ?> info = eventValues.get(i);
            if (info.event.isAssignableFrom(e) && info.event != e || info.event == e && info.c.isAssignableFrom(c)) {
                eventValues.add(i, new EventValueInfo<E, T>(e, c, g, excludeErrorMessage, excludes));
                return;
            }
            ++i;
        }
        eventValues.add(new EventValueInfo<E, T>(e, c, g, excludeErrorMessage, excludes));
    }

    public static <T, E extends Event> T getEventValue(E e, Class<T> c, int time) {
        SerializableGetter<T, ?> g = Skript.getEventValueGetter(e.getClass(), c, time);
        if (g == null) {
            return null;
        }
        return (T)g.get(e);
    }

    public static final <T, E extends Event> SerializableGetter<? extends T, ? super E> getEventValueGetter(Class<E> e, Class<T> c, int time) {
        return Skript.getEventValueGetter(e, c, time, true);
    }

    private static final <T, E extends Event> SerializableGetter<? extends T, ? super E> getEventValueGetter(Class<E> e, final Class<T> c, int time, boolean allowDefault) {
        List<EventValueInfo<?, ?>> eventValues = Skript.getEventValuesList(time);
        for (final EventValueInfo<?, ?> ev : eventValues) {
            if (!ev.event.isAssignableFrom(e) || !c.isAssignableFrom(ev.c)) continue;
            if (!Skript.checkExcludes(ev, e, true)) {
                return null;
            }
            return ev.getter;
        }
        for (final EventValueInfo<?, ?> ev : eventValues) {
            if (!ev.event.isAssignableFrom(e) || !ev.c.isAssignableFrom(c)) continue;
            if (!Skript.checkExcludes(ev, e, true)) {
                return null;
            }
            return new SerializableGetter<T, E>(){
                private static final long serialVersionUID = 2791282476327758686L;

                @Override
                public T get(E e) {
                    Object o = ev.getter.get(e);
                    if (c.isInstance(o)) {
                        return o;
                    }
                    return null;
                }
            };
        }
        for (final EventValueInfo<?, ?> ev : eventValues) {
            if (!ev.event.isAssignableFrom(e)) continue;
            if (!Skript.checkExcludes(ev, e, true)) {
                return null;
            }
            SerializableGetter<T, ?> g = Skript.getConvertedGetter(ev, c);
            if (g == null) continue;
            return g;
        }
        if (allowDefault && time != 0) {
            return Skript.getEventValueGetter(e, c, 0);
        }
        return null;
    }

    private static final boolean checkExcludes(EventValueInfo<?, ?> ev, Class<? extends Event> e, boolean printError) {
        if (ev.exculdes == null) {
            return true;
        }
        Class<? extends E>[] classArray = ev.exculdes;
        int n = ev.exculdes.length;
        int n2 = 0;
        while (n2 < n) {
            Class ex = classArray[n2];
            if (ex.isAssignableFrom(e)) {
                if (printError) {
                    Skript.error(ev.excludeErrorMessage);
                }
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static final <E extends Event, F, T> SerializableGetter<? extends T, ? super E> getConvertedGetter(final EventValueInfo<E, F> i, Class<T> to) {
        final SerializableConverter c = Skript.getConverter(i.c, to);
        if (c == null) {
            return null;
        }
        return new SerializableGetter<T, E>(){
            private static final long serialVersionUID = 3284436987168293139L;

            @Override
            public T get(E e) {
                Object f = i.getter.get(e);
                if (f == null) {
                    return null;
                }
                return c.convert(f);
            }
        };
    }

    public static final boolean doesEventValueHaveTimeStates(Class<? extends Event> e, Class<?> c) {
        return Skript.getEventValueGetter(e, c, -1, false) != null || Skript.getEventValueGetter(e, c, 1, false) != null;
    }

    public static final boolean dispatchCommand(CommandSender sender, String command) {
        if (sender instanceof Player) {
            PlayerCommandPreprocessEvent e = new PlayerCommandPreprocessEvent((Player)sender, "/" + command);
            Bukkit.getPluginManager().callEvent((Event)e);
            if (e.isCancelled() || !e.getMessage().startsWith("/")) {
                return false;
            }
            return Bukkit.dispatchCommand((CommandSender)e.getPlayer(), (String)e.getMessage().substring(1));
        }
        ServerCommandEvent e = new ServerCommandEvent(sender, command);
        Bukkit.getPluginManager().callEvent((Event)e);
        if (e.getCommand() == null || e.getCommand().isEmpty()) {
            return false;
        }
        return Bukkit.dispatchCommand((CommandSender)e.getSender(), (String)e.getCommand());
    }

    public static final boolean logNormal() {
        return SkriptLogger.log(Verbosity.NORMAL);
    }

    public static final boolean logHigh() {
        return SkriptLogger.log(Verbosity.HIGH);
    }

    public static final boolean logVeryHigh() {
        return SkriptLogger.log(Verbosity.VERY_HIGH);
    }

    public static final boolean debug() {
        return SkriptLogger.debug();
    }

    public static final boolean log(Verbosity minVerb) {
        return SkriptLogger.log(minVerb);
    }

    public static void config(String info) {
        SkriptLogger.log(Level.CONFIG, info);
    }

    public static void info(String info) {
        SkriptLogger.log(Level.INFO, info);
    }

    public static void warning(String warning) {
        SkriptLogger.log(Level.WARNING, warning);
    }

    public static void error(String error) {
        SkriptLogger.log(Level.SEVERE, error);
    }

    public static void error(String error, ErrorQuality quality) {
        SkriptLogger.error(new LogEntry(Level.SEVERE, error), quality);
    }

    public static final RuntimeException exception(String ... info) {
        return Skript.exception(null, info);
    }

    public static final EmptyStackException exception(Throwable cause, String ... info) {
        Skript.logEx();
        Skript.logEx("[Skript] Severe Error:");
        Skript.logEx(info);
        Skript.logEx();
        Skript.logEx("If you're developping an add-on for Skript this likely means that you have done something wrong.");
        Skript.logEx("If you're a server admin however please go to http://dev.bukkit.org/server-mods/skript/tickets/");
        Skript.logEx("and check whether this error has already been reported.");
        Skript.logEx("If not please create a new ticket with a meaningful title, copy & paste this whole error into it,");
        Skript.logEx("and describe what you did before it happened and/or what you think caused the error.");
        Skript.logEx("If you feel like it's a trigger that's causing the error please post the trigger as well.");
        Skript.logEx("By following this guide fixing the error should be easy and done fast.");
        Skript.logEx();
        Skript.logEx("Stacktrace:");
        if (cause == null || cause.getStackTrace().length == 0) {
            Skript.logEx("  warning: no/empty exception given, dumping current stack trace instead");
            cause = new Exception(cause);
        }
        Skript.logEx(cause.toString());
        StackTraceElement[] stackTraceElementArray = cause.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            Skript.logEx("    at " + e.toString());
            ++n2;
        }
        Skript.logEx();
        Skript.logEx("Version Information:");
        Skript.logEx("  Skript: " + Skript.getInstance().getDescription().getVersion());
        Skript.logEx("  Bukkit: " + Bukkit.getBukkitVersion());
        Skript.logEx("  Java: " + System.getProperty("java.version"));
        Skript.logEx();
        Skript.logEx("Running CraftBukkit: " + runningCraftBukkit);
        Skript.logEx();
        Skript.logEx("Current node: " + SkriptLogger.getNode());
        Skript.logEx();
        Skript.logEx("Current thread: " + Thread.currentThread().getName());
        Skript.logEx();
        Skript.logEx("End of Error.");
        Skript.logEx();
        return new EmptyStackException();
    }

    private static final void logEx() {
        Bukkit.getLogger().severe(EXCEPTION_PREFIX);
    }

    private static final void logEx(String ... lines) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Bukkit.getLogger().severe(EXCEPTION_PREFIX + line);
            ++n2;
        }
    }

    public static void info(CommandSender sender, String info) {
        sender.sendMessage(String.valueOf(skriptPrefix) + Utils.replaceEnglishChatStyles(info));
    }

    public static void broadcast(String message, String permission) {
        Bukkit.broadcast((String)(String.valueOf(skriptPrefix) + Utils.replaceEnglishChatStyles(message)), (String)permission);
    }

    public static void adminBroadcast(String message) {
        Bukkit.broadcast((String)(String.valueOf(skriptPrefix) + Utils.replaceEnglishChatStyles(message)), (String)"skript.admin");
    }

    public static void message(CommandSender sender, String info) {
        sender.sendMessage(Utils.replaceEnglishChatStyles(info));
    }

    public static void error(CommandSender sender, String error) {
        sender.sendMessage(String.valueOf(skriptPrefix) + ChatColor.DARK_RED + Utils.replaceEnglishChatStyles(error));
    }

    public static String getSyntaxElementName(Class<? extends SyntaxElement> c) {
        if (Condition.class.isAssignableFrom(c)) {
            return "condition";
        }
        if (Effect.class.isAssignableFrom(c)) {
            return "effect";
        }
        if (Expression.class.isAssignableFrom(c)) {
            return "expression";
        }
        return "syntax element";
    }

    static final class EventValueInfo<E extends Event, T>
    implements Serializable {
        private static final long serialVersionUID = 2208751466806346720L;
        final Class<E> event;
        final Class<T> c;
        final SerializableGetter<T, E> getter;
        final Class<? extends E>[] exculdes;
        final String excludeErrorMessage;

        public EventValueInfo(Class<E> event, Class<T> c, SerializableGetter<T, E> getter) {
            Validate.notNull(event, c, getter);
            this.event = event;
            this.c = c;
            this.getter = getter;
            this.exculdes = null;
            this.excludeErrorMessage = null;
        }

        public EventValueInfo(Class<E> event, Class<T> c, SerializableGetter<T, E> getter, String excludeErrorMessage, Class<? extends E>[] exculdes) {
            Validate.notNull(event, c, getter);
            this.event = event;
            this.c = c;
            this.getter = getter;
            this.exculdes = exculdes;
            this.excludeErrorMessage = excludeErrorMessage;
        }
    }

    public static enum ExpressionType {
        SIMPLE,
        NORMAL,
        COMBINED,
        PROPERTY,
        PATTERN_MATCHES_EVERYTHING;

    }
}

