/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Config;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Pattern;

public class Language {
    private static String name = "english";
    private static Config english;
    private static Config localized;
    private static boolean useLocal;
    private static final Pattern split;
    private static final Collection<LanguageChangeListener> listeners;

    static {
        useLocal = false;
        split = Pattern.compile("\\s*,\\s*");
        listeners = new HashSet<LanguageChangeListener>();
    }

    public static String getName() {
        return name;
    }

    private static final String get_i(String key) {
        String s;
        if (useLocal && localized != null && (s = localized.getByPath(key)) != null) {
            return s;
        }
        return english.getByPath(key);
    }

    public static String get(String key) {
        String s = Language.get_i(key.toLowerCase(Locale.ENGLISH));
        if (s == null) {
            return key.toLowerCase(Locale.ENGLISH);
        }
        return s;
    }

    public static String format(String key, Object ... args) {
        String value = Language.get_i(key = key.toLowerCase(Locale.ENGLISH));
        if (value == null) {
            return key;
        }
        try {
            return String.format(value, args);
        }
        catch (Exception e) {
            return key;
        }
    }

    public static String getSpaced(String key) {
        String s = Language.get(key.toLowerCase(Locale.ENGLISH));
        if (s.isEmpty()) {
            return " ";
        }
        return " " + s + " ";
    }

    public static String[] getList(String key) {
        String s = Language.get_i(key.toLowerCase(Locale.ENGLISH));
        if (s == null) {
            return new String[]{key.toLowerCase(Locale.ENGLISH)};
        }
        return split.split(s);
    }

    static void loadDefault() {
        InputStream din = Skript.getInstance().getResource("lang/english.lang");
        if (din == null) {
            throw new IllegalStateException("Skript.jar is missing the required english.lang file!");
        }
        try {
            try {
                english = new Config(din, "english.lang", false, false, ":");
            }
            catch (IOException e) {
                throw Skript.exception(e, "Could not load the default language file!");
            }
        }
        finally {
            try {
                din.close();
            }
            catch (IOException iOException) {}
        }
        for (LanguageChangeListener l : listeners) {
            l.onLanguageChange();
        }
    }

    static boolean load(String name) {
        name = name.toLowerCase();
        InputStream in = Skript.getInstance().getResource("lang/" + name + ".lang");
        if (in == null) {
            return false;
        }
        try {
            try {
                localized = new Config(in, String.valueOf(name) + ".lang", false, false, ":");
            }
            catch (IOException e) {
                Skript.exception(e, "Could not load the language file '" + name + ".lang'!");
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        Language.name = name;
        if (useLocal) {
            for (LanguageChangeListener l : listeners) {
                l.onLanguageChange();
            }
        }
        return true;
    }

    public static void addListener(LanguageChangeListener l) {
        listeners.add(l);
        if (english != null) {
            l.onLanguageChange();
        }
    }

    public static void removeListener(LanguageChangeListener l) {
        listeners.remove(l);
    }

    public static void setUseLocal(boolean b) {
        if (useLocal == b) {
            return;
        }
        useLocal = b;
        for (LanguageChangeListener l : listeners) {
            l.onLanguageChange();
        }
    }

    public static interface LanguageChangeListener {
        public void onLanguageChange();
    }
}

