/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.util.Color;
import ch.njol.util.Callback;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import ch.njol.util.Validate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public abstract class Utils {
    private static final Random random = new Random();
    private static final String[][] plurals = new String[][]{{"fe", "ves"}, {"axe", "axes"}, {"x", "xes"}, {"ay", "ays"}, {"ey", "eys"}, {"iy", "iys"}, {"oy", "oys"}, {"uy", "uys"}, {"kie", "kies"}, {"zombie", "zombies"}, {"y", "ies"}, {"h", "hes"}, {"man", "men"}, {"us", "i"}, {"hoe", "hoes"}, {"toe", "toes"}, {"o", "oes"}, {"alias", "aliases"}, {"gas", "gases"}, {"child", "children"}, {"sheep", "sheep"}, {"", "s"}};
    private static final Map<String, String> chat = new HashMap<String, String>();
    private static final double sqrt2i;

    static {
        chat.put("bold", ChatColor.BOLD.toString());
        chat.put("b", ChatColor.BOLD.toString());
        chat.put("italics", ChatColor.ITALIC.toString());
        chat.put("italic", ChatColor.ITALIC.toString());
        chat.put("i", ChatColor.ITALIC.toString());
        chat.put("strikethrough", ChatColor.STRIKETHROUGH.toString());
        chat.put("strike", ChatColor.STRIKETHROUGH.toString());
        chat.put("s", ChatColor.STRIKETHROUGH.toString());
        chat.put("underlined", ChatColor.UNDERLINE.toString());
        chat.put("underline", ChatColor.UNDERLINE.toString());
        chat.put("u", ChatColor.UNDERLINE.toString());
        chat.put("magic", ChatColor.MAGIC.toString());
        chat.put("reset", ChatColor.RESET.toString());
        chat.put("<none>", "");
        sqrt2i = 1.0 / Math.sqrt(2.0);
    }

    private Utils() {
    }

    public static <T> int indexOf(T[] array, T t) {
        return Utils.indexOf(array, t, 0, array.length);
    }

    public static <T> int indexOf(T[] array, T t, int start, int end) {
        Validate.notNull(array, "array");
        int i = start;
        while (i < end) {
            if (array[i] == null ? t == null : array[i].equals(t)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> boolean contains(T[] array, T o) {
        return Utils.indexOf(array, o) != -1;
    }

    public static <T> boolean containsAny(T[] array, T ... os) {
        Validate.notNull(array, os);
        T[] TArray = os;
        int n = os.length;
        int n2 = 0;
        while (n2 < n) {
            T o = TArray[n2];
            if (Utils.indexOf(array, o) != -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> boolean containsAll(T[] array, T ... os) {
        Validate.notNull(array, os);
        T[] TArray = os;
        int n = os.length;
        int n2 = 0;
        while (n2 < n) {
            T o = TArray[n2];
            if (Utils.indexOf(array, o) == -1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static int indexOf(int[] array, int num) {
        return Utils.indexOf(array, num, 0, array.length);
    }

    public static int indexOf(int[] array, int num, int start) {
        return Utils.indexOf(array, num, start, array.length);
    }

    public static int indexOf(int[] array, int num, int start, int end) {
        Validate.notNull((Object)array, "array");
        int i = start;
        while (i < end) {
            if (array[i] == num) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final boolean contains(int[] array, int num) {
        return Utils.indexOf(array, num) != -1;
    }

    public static boolean containsIgnoreCase(String[] array, String s) {
        return Utils.indexOfIgnoreCase(array, s) != -1;
    }

    public static int indexOfIgnoreCase(String[] array, String s) {
        Validate.notNull((Object)array, "array");
        int i = 0;
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (a.equalsIgnoreCase(s)) {
                return i;
            }
            ++i;
            ++n2;
        }
        return -1;
    }

    public static <T> int indexOf(Iterable<T> iter, T o) {
        Validate.notNull(iter, "iter");
        int i = 0;
        for (T a : iter) {
            if (a.equals(o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(Iterable<String> iter, String s) {
        Validate.notNull(iter, "iter");
        int i = 0;
        for (String a : iter) {
            if (a.equalsIgnoreCase(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T, U> Map.Entry<T, U> containsKey(Map<T, U> map, T key) {
        Validate.notNull(map, "map");
        U u = map.get(key);
        if (u == null) {
            return null;
        }
        return new Pair<T, U>(key, u);
    }

    public static <U> Map.Entry<String, U> containsKeyIgnoreCase(Map<String, U> map, String key) {
        Validate.notNull(map, "map");
        for (Map.Entry<String, U> e : map.entrySet()) {
            if (!e.getKey().equalsIgnoreCase(key)) continue;
            return e;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BlockFace getBlockFace(String s, boolean printError) {
        String supper;
        block18: {
            Validate.notNullOrEmpty(s, "s");
            supper = s.toUpperCase().replace(' ', '_');
            try {
                if (supper.equals("ABOVE")) {
                    return BlockFace.UP;
                }
                if (supper.equals("BELOW")) {
                    return BlockFace.DOWN;
                }
                return BlockFace.valueOf((String)supper);
            }
            catch (IllegalArgumentException e1) {
                if (supper.equals("U")) {
                    return BlockFace.UP;
                }
                if (supper.equals("D")) {
                    return BlockFace.DOWN;
                }
                if (supper.length() > 3) break block18;
                try {
                    String r = "";
                    int i = 0;
                    while (true) {
                        if (i >= supper.length()) {
                            return BlockFace.valueOf((String)r.substring(0, r.length() - 1));
                        }
                        switch (supper.charAt(i)) {
                            case 'N': {
                                r = String.valueOf(r) + "NORTH_";
                                break;
                            }
                            case 'E': {
                                r = String.valueOf(r) + "EAST_";
                                break;
                            }
                            case 'S': {
                                r = String.valueOf(r) + "SOUTH_";
                                break;
                            }
                            case 'W': {
                                r = String.valueOf(r) + "WEST_";
                                break;
                            }
                            default: {
                                if (printError) {
                                    Skript.error("invalid direction '" + s + "'");
                                }
                                return null;
                            }
                        }
                        ++i;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (printError) {
            Skript.error("invalid direction '" + supper + "'");
        }
        return null;
    }

    public static final int[] getBlockFaceDir(BlockFace f) {
        Validate.notNull((Object)f, "f");
        return new int[]{f.getModX(), f.getModY(), f.getModZ()};
    }

    public static final int getBlockFaceDir(BlockFace f, int axis) {
        Validate.notNull((Object)f, "f");
        switch (axis) {
            case 0: {
                return f.getModX();
            }
            case 1: {
                return f.getModY();
            }
            case 2: {
                return f.getModZ();
            }
        }
        throw new IllegalArgumentException("axis must be between 0 and 2 inclusive");
    }

    public static String join(String[] strings) {
        return Utils.join(strings, ", ");
    }

    public static String join(String[] strings, String delimiter) {
        return Utils.join(strings, delimiter, 0, strings.length);
    }

    public static String join(String[] strings, String delimiter, int start, int end) {
        Validate.notNull((Object)strings, "strings");
        StringBuilder b = new StringBuilder();
        int i = start;
        while (i < end) {
            if (i != start) {
                b.append(delimiter);
            }
            b.append(strings[i]);
            ++i;
        }
        return b.toString();
    }

    public static String join(Object[] objects) {
        Validate.notNull((Object)objects, "objects");
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < objects.length) {
            if (i != 0) {
                b.append(", ");
            }
            b.append(Skript.toString(objects[i]));
            ++i;
        }
        return b.toString();
    }

    public static String join(List<?> objects) {
        Validate.notNull(objects, "objects");
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < objects.size()) {
            if (i != 0) {
                b.append(", ");
            }
            b.append(Skript.toString(objects.get(i)));
            ++i;
        }
        return b.toString();
    }

    public static <T> T getRandom(T[] os) {
        Validate.notNullOrEmpty(os, "os");
        return os[Skript.random.nextInt(os.length)];
    }

    public static <T> T getRandom(T[] os, int start) {
        Validate.notNullOrEmpty(os, "os");
        return os[Skript.random.nextInt(os.length - start) + start];
    }

    public static <T> T getRandom(List<T> os) {
        Validate.notNullOrEmpty(os, "os");
        return os.get(Skript.random.nextInt(os.size()));
    }

    public static boolean itemStacksEqual(ItemStack is1, ItemStack is2) {
        if (is1 == null || is2 == null) {
            return is1 == is2;
        }
        return is1.getTypeId() == is2.getTypeId() && is1.getDurability() == is2.getDurability() && is1.getEnchantments().equals(is2.getEnchantments());
    }

    public static <T extends Entity> T getTarget(LivingEntity entity, EntityData<T> type) {
        Validate.notNull((Object)entity, "entity");
        if (entity instanceof Creature) {
            return (T)(type.isInstance((Entity)((Creature)entity).getTarget()) ? ((Creature)entity).getTarget() : null);
        }
        Entity target = null;
        double targetDistanceSquared = 0.0;
        double radiusSquared = 1.0;
        Vector l = entity.getEyeLocation().toVector();
        Vector n = entity.getLocation().getDirection().normalize();
        double cos45 = Math.cos(0.7853981633974483);
        for (Entity other : entity.getWorld().getEntitiesByClass(type.getType())) {
            if (other == entity || !type.isInstance(other) || target != null && !(targetDistanceSquared > other.getLocation().distanceSquared(entity.getLocation()))) continue;
            Vector t = other.getLocation().add(0.0, 1.0, 0.0).toVector().subtract(l);
            if (!(n.clone().crossProduct(t).lengthSquared() < 1.0) || !(t.normalize().dot(n) >= cos45)) continue;
            target = other;
            targetDistanceSquared = target.getLocation().distanceSquared(entity.getLocation());
        }
        return (T)target;
    }

    public static final Pair<String, Integer> getAmount(String s) {
        if (s.matches("\\d+ of .+")) {
            return new Pair<String, Integer>(s.split(" ", 3)[2], Skript.parseInt(s.split(" ", 2)[0]));
        }
        if (s.matches("\\d+ .+")) {
            return new Pair<String, Integer>(s.split(" ", 2)[1], Skript.parseInt(s.split(" ", 2)[0]));
        }
        if (s.matches("an? .+")) {
            return new Pair<String, Integer>(s.split(" ", 2)[1], 1);
        }
        return new Pair<String, Integer>(s, -1);
    }

    public static final AmountResponse getAmountWithEvery(String s) {
        if (s.matches("\\d+ of (all|every) .+")) {
            return new AmountResponse(s.split(" ", 4)[3], Skript.parseInt(s.split(" ", 2)[0]), true);
        }
        if (s.matches("\\d+ of .+")) {
            return new AmountResponse(s.split(" ", 3)[2], Skript.parseInt(s.split(" ", 2)[0]));
        }
        if (s.matches("\\d+ .+")) {
            return new AmountResponse(s.split(" ", 2)[1], Skript.parseInt(s.split(" ", 2)[0]));
        }
        if (s.matches("an? .+")) {
            return new AmountResponse(s.split(" ", 2)[1], 1);
        }
        if (s.matches("(all|every) .+")) {
            return new AmountResponse(s.split(" ", 2)[1], true);
        }
        return new AmountResponse(s);
    }

    public static final Pair<String, Boolean> getPlural(String s) {
        Validate.notNull((Object)s, "s");
        if (s.isEmpty()) {
            return new Pair<String, Boolean>("", Boolean.FALSE);
        }
        String[][] stringArray = plurals;
        int n = plurals.length;
        int n2 = 0;
        while (n2 < n) {
            String[] p = stringArray[n2];
            if (s.endsWith(p[1])) {
                return new Pair<String, Boolean>(String.valueOf(s.substring(0, s.length() - p[1].length())) + p[0], Boolean.TRUE);
            }
            if (s.endsWith(p[1].toUpperCase())) {
                return new Pair<String, Boolean>(String.valueOf(s.substring(0, s.length() - p[1].length())) + p[0].toUpperCase(), Boolean.TRUE);
            }
            ++n2;
        }
        return new Pair<String, Boolean>(s, Boolean.FALSE);
    }

    public static final String toPlural(String s) {
        Validate.notNullOrEmpty(s, "s");
        String[][] stringArray = plurals;
        int n = plurals.length;
        int n2 = 0;
        while (n2 < n) {
            String[] p = stringArray[n2];
            if (s.endsWith(p[0])) {
                return String.valueOf(s.substring(0, s.length() - p[0].length())) + p[1];
            }
            ++n2;
        }
        assert (false);
        return String.valueOf(s) + "s";
    }

    public static final String toPlural(String s, boolean p) {
        if (p) {
            return Utils.toPlural(s);
        }
        return s;
    }

    public static final String a(String s) {
        return Utils.a(s, false);
    }

    public static final String A(String s) {
        return Utils.a(s, true);
    }

    public static final String a(String s, boolean capA) {
        Validate.notNullOrEmpty(s, "s");
        switch (Character.toLowerCase(s.charAt(0))) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                if (capA) {
                    return "An " + s;
                }
                return "an " + s;
            }
        }
        if (capA) {
            return "A " + s;
        }
        return "a " + s;
    }

    public static double getBlockHeight(Material type) {
        Validate.notNull((Object)type, "type");
        switch (type) {
            case DIODE_BLOCK_OFF: 
            case DIODE_BLOCK_ON: {
                return 0.125;
            }
            case TRAP_DOOR: {
                return 0.1875;
            }
            case CAKE_BLOCK: {
                return 0.4375;
            }
            case STEP: {
                return 0.5;
            }
            case BED_BLOCK: {
                return 0.5625;
            }
            case ENCHANTMENT_TABLE: {
                return 0.75;
            }
            case ENDER_PORTAL_FRAME: {
                return 0.8125;
            }
            case SOUL_SAND: {
                return 0.875;
            }
            case BREWING_STAND: {
                return 0.875;
            }
            case FENCE: 
            case FENCE_GATE: 
            case NETHER_FENCE: {
                return 1.5;
            }
            case CAULDRON: {
                return 0.3125;
            }
        }
        return 1.0;
    }

    public static final String prepareMessage(String message) {
        Validate.notNull((Object)message, "message");
        message = Utils.replaceChatStyles(message);
        message = StringUtils.fixCapitalization(message);
        return message;
    }

    public static final String replaceChatStyles(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        message = StringUtils.replaceAll(message, "<([^<>]+|<none>)>", new Callback<String, Matcher>(){

            @Override
            public String run(Matcher m) {
                Color c = Color.byName(m.group(1));
                if (c != null) {
                    return c.getChat();
                }
                String f = (String)chat.get(m.group(1).toLowerCase());
                if (f != null) {
                    return f;
                }
                return m.group();
            }
        });
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        return message;
    }

    public static final <E extends Entity> E validate(E e) {
        if (e == null) {
            return null;
        }
        if (e instanceof Player) {
            Player p = Bukkit.getPlayerExact((String)((Player)e).getName());
            return (E)(p == null ? e : p);
        }
        return e;
    }

    public static final BlockFace getFacing(Location loc, boolean horizontal) {
        Vector dir = loc.getDirection();
        if (!horizontal) {
            if (dir.getY() > sqrt2i) {
                return BlockFace.UP;
            }
            if (dir.getY() < sqrt2i) {
                return BlockFace.DOWN;
            }
        }
        BlockFace[] blockFaceArray = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
        int n = blockFaceArray.length;
        int n2 = 0;
        while (n2 < n) {
            BlockFace f = blockFaceArray[n2];
            if ((double)f.getModX() * dir.getX() + (double)f.getModZ() * dir.getZ() >= sqrt2i - 1.0E-10) {
                return f;
            }
            ++n2;
        }
        assert (false);
        return null;
    }

    public static final int[] permutation(int start, int end) {
        int length = end - start + 1;
        int[] r = new int[length];
        int i = 0;
        while (i < length) {
            r[i] = start + i;
            ++i;
        }
        i = 0;
        while (i < length) {
            int j = random.nextInt(length);
            int b = r[i];
            r[i] = r[j];
            r[j] = b;
            ++i;
        }
        return r;
    }

    public static int random(int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("end (" + end + ") must be >= start (" + start + ")");
        }
        return start + random.nextInt(end - start + 1);
    }

    public static final class AmountResponse {
        public final String s;
        public final int amount;
        public final boolean every;

        public AmountResponse(String s, int amount, boolean every) {
            this.s = s;
            this.amount = amount;
            this.every = every;
        }

        public AmountResponse(String s, boolean every) {
            this.s = s;
            this.amount = -1;
            this.every = every;
        }

        public AmountResponse(String s, int amount) {
            this.s = s;
            this.amount = amount;
            this.every = false;
        }

        public AmountResponse(String s) {
            this.s = s;
            this.amount = -1;
            this.every = false;
        }
    }
}

