/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.log;

import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.iterator.IteratorIterable;
import java.util.Deque;
import java.util.LinkedList;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;

public final class SubLog {
    final Deque<LogEntry> log = new LinkedList<LogEntry>();

    SubLog() {
    }

    public final boolean printErrors(String def) {
        this.stop();
        boolean hasError = false;
        for (LogEntry e : this.log) {
            if (e.getLevel() != Level.SEVERE) continue;
            SkriptLogger.log(e);
            hasError = true;
        }
        if (!hasError && def != null) {
            SkriptLogger.log(Level.SEVERE, def);
        }
        return hasError;
    }

    public final boolean printErrors(CommandSender recipient, String def) {
        this.stop();
        boolean hasError = false;
        for (LogEntry e : this.log) {
            if (e.getLevel() != Level.SEVERE) continue;
            recipient.sendMessage(e.getMessage());
            hasError = true;
        }
        if (!hasError && def != null) {
            recipient.sendMessage(def);
        }
        return hasError;
    }

    public final void printLog() {
        this.stop();
        SkriptLogger.logAll(this.log);
    }

    public boolean hasErrors() {
        for (LogEntry e : this.log) {
            if (e.getLevel() != Level.SEVERE) continue;
            return true;
        }
        return false;
    }

    public LogEntry getLastError() {
        for (LogEntry e : new IteratorIterable<LogEntry>(this.log.descendingIterator())) {
            if (e.getLevel() != Level.SEVERE) continue;
            return e;
        }
        return null;
    }

    public void clear() {
        this.log.clear();
    }

    public int size() {
        return this.log.size();
    }

    public void stop() {
        SkriptLogger.stopSubLog(this);
    }
}

