/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.log;

import ch.njol.skript.config.Node;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.SubLog;
import ch.njol.skript.log.Verbosity;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public abstract class SkriptLogger {
    private static Node node = null;
    private static Verbosity verbosity = Verbosity.NORMAL;
    static boolean debug;
    private static final Deque<SubLog> subLogs;
    private static int numErrors;

    static {
        subLogs = new LinkedList<SubLog>();
        numErrors = 0;
    }

    public static final SubLog startSubLog() {
        SubLog subLog = new SubLog();
        subLogs.addLast(subLog);
        return subLog;
    }

    public static final void stopSubLog(SubLog log) {
        if (!subLogs.contains(log)) {
            return;
        }
        if (subLogs.removeLast() != log) {
            int i = 1;
            while (subLogs.removeLast() != log) {
                ++i;
            }
            Bukkit.getLogger().severe("[Skript] " + i + " sub log(s) was/were not stopped properly!");
        }
    }

    public static void setVerbosity(Verbosity v) {
        verbosity = v;
        if (v.compareTo(Verbosity.DEBUG) >= 0) {
            debug = true;
        }
    }

    public static void setNode(Node node) {
        SkriptLogger.node = node == null || node.getParent() == null ? null : node;
    }

    public static Node getNode() {
        return node;
    }

    public static void log(Level level, String message) {
        SkriptLogger.log(new LogEntry(level, message, node));
    }

    public static void log(LogEntry entry) {
        if (!subLogs.isEmpty()) {
            SkriptLogger.subLogs.getLast().log.add(entry);
        } else {
            Bukkit.getLogger().log(entry.getLevel(), "[Skript] " + entry.getMessage());
            if (entry.getLevel() == Level.SEVERE) {
                ++numErrors;
            }
        }
    }

    public static void logAll(Collection<LogEntry> entries) {
        if (!subLogs.isEmpty()) {
            SkriptLogger.subLogs.getLast().log.addAll(entries);
        } else {
            for (LogEntry entry : entries) {
                Bukkit.getLogger().log(entry.getLevel(), "[Skript] " + entry.getMessage());
                if (entry.getLevel() != Level.SEVERE) continue;
                ++numErrors;
            }
        }
    }

    public static boolean log(Verbosity minVerb) {
        return minVerb.compareTo(verbosity) <= 0;
    }

    public static boolean debug() {
        return debug;
    }

    public static int getNumErrors() {
        return numErrors;
    }
}

