/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.log;

import ch.njol.skript.config.Node;
import ch.njol.skript.log.SkriptLogger;
import java.util.logging.Level;

public class LogEntry {
    private final Level level;
    private final String message;
    private Node node = null;

    public LogEntry(Level level, String message) {
        this.level = level;
        this.message = message;
        this.node = SkriptLogger.getNode();
    }

    public LogEntry(Level level, String message, Node node) {
        this(level, message);
        this.node = node;
    }

    public void setNode(Node node) {
        if (node != null) {
            this.node = node;
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.toString();
    }

    public String toString() {
        if (this.node == null || this.level.intValue() < Level.WARNING.intValue()) {
            return this.message;
        }
        return String.valueOf(this.message) + " (" + this.node.getConfig().getFileName() + ", line " + this.node.getLine() + (this.node.getOrig() == null ? "" : ": '" + this.node.getOrig().trim() + "')");
    }
}

