/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.Variables;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.lang.util.VariableString;
import ch.njol.skript.util.StringMode;
import ch.njol.util.Checker;
import ch.njol.util.StringUtils;
import ch.njol.util.Validate;
import ch.njol.util.iterator.NonNullIterator;
import java.lang.reflect.Array;
import org.bukkit.event.Event;

public class Variable<T>
implements Expression<T> {
    private final VariableString name;
    private final boolean local;
    private final Class<T> type;
    private final Variable<?> source;

    private Variable(VariableString name, Class<T> type, Variable<?> source) {
        Validate.notNull(name, type);
        if (name.getMode() != StringMode.VARIABLE_NAME) {
            throw new IllegalArgumentException("'name' must be a VARIABLE_NAME string");
        }
        this.local = name.getDefaultVariableName().startsWith("*");
        this.name = name;
        this.type = type;
        this.source = source;
    }

    public Variable(VariableString name, Class<T> type) {
        this(name, type, null);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.type;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e != null) {
            return Skript.toString(this.get(e));
        }
        return "{" + StringUtils.substring(this.name.toString(e, debug), 1, -1) + "}" + (debug ? "(as " + this.type.getName() + ")" : "");
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    @Override
    public <R> Expression<? extends R> getConvertedExpression(Class<R> to) {
        return new Variable<R>(this.name, to, this);
    }

    private Object get(Event e) {
        if (this.local) {
            return Variables.getLocalVariable(this.name.toString(e).toLowerCase(), e);
        }
        Object val = Variables.getVariable(this.name.toString(e).toLowerCase());
        if (val == null) {
            return Variables.getVariable(this.name.getDefaultVariableName().toLowerCase());
        }
        return val;
    }

    private T getConverted(Event e) {
        return Skript.convert(this.get(e), this.type);
    }

    private final void set(Event e, Object value) {
        if (this.local) {
            Variables.setLocalVariable(this.name.toString(e).toLowerCase(), e, value);
        } else {
            Variables.setVariable(this.name.toString(e).toLowerCase(), value);
        }
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return Object.class;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        switch (mode) {
            case CLEAR: {
                this.set(e, null);
                break;
            }
            case SET: {
                ClassInfo<?> ci;
                ClassInfo<?> classInfo = ci = delta == null ? null : Skript.getSuperClassInfo(delta.getClass());
                if (ci != null && ci.getSerializeAs() != null) {
                    this.set(e, Skript.convert(delta, ci.getSerializeAs()));
                    break;
                }
                this.set(e, delta);
                break;
            }
            case ADD: 
            case REMOVE: {
                ClassInfo<?> ci;
                if (delta == null) break;
                Object o = this.get(e);
                if ((o == null || o instanceof Number) && delta instanceof Number) {
                    int i = mode == Changer.ChangeMode.ADD ? 1 : -1;
                    this.set(e, (o == null ? 0.0 : ((Number)o).doubleValue()) + (double)i * ((Number)delta).doubleValue());
                    break;
                }
                if (o == null || (ci = Skript.getSuperClassInfo(o.getClass())).getChanger() == null || ci.getChanger().acceptChange(mode) == null) break;
                Class<?> c = ci.getChanger().acceptChange(mode);
                Object[] one = (Object[])Array.newInstance(o.getClass(), 1);
                one[0] = o;
                if (c.isAssignableFrom(delta.getClass())) {
                    Changer.ChangerUtils.change(ci.getChanger(), one, delta, mode);
                    break;
                }
                if (!c.isArray() || !c.getComponentType().isAssignableFrom(delta.getClass())) break;
                Object[] deltas = (Object[])Array.newInstance(c.getComponentType(), 1);
                deltas[0] = delta;
                Changer.ChangerUtils.change(ci.getChanger(), one, deltas, mode);
            }
        }
    }

    @Override
    public T getSingle(Event e) {
        return this.getConverted(e);
    }

    @Override
    public T[] getArray(Event e) {
        return this.getAll(e);
    }

    @Override
    public T[] getAll(Event e) {
        T o = this.getConverted(e);
        if (o == null) {
            return (Object[])Array.newInstance(this.type, 0);
        }
        Object[] one = (Object[])Array.newInstance(this.type, 1);
        one[0] = o;
        return one;
    }

    @Override
    public boolean check(Event e, Checker<? super T> c, Condition cond) {
        return SimpleExpression.check(this.getAll(e), c, cond.isNegated(), this.getAnd());
    }

    @Override
    public boolean check(Event e, Checker<? super T> c) {
        return SimpleExpression.check(this.getAll(e), c, false, this.getAnd());
    }

    @Override
    public boolean getAnd() {
        return false;
    }

    @Override
    public boolean setTime(int time) {
        return false;
    }

    @Override
    public int getTime() {
        return 0;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public boolean canLoop() {
        return false;
    }

    @Override
    public NonNullIterator<T> iterator(Event e) {
        return null;
    }

    @Override
    public boolean isLoopOf(String s) {
        return false;
    }

    @Override
    public Expression<?> getSource() {
        return this.source == null ? this : this.source;
    }
}

