/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions.base;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Validator;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.log.SubLog;
import ch.njol.skript.util.Getter;
import ch.njol.util.Validate;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.event.Event;

public class EventValueExpression<T>
extends SimpleExpression<T>
implements DefaultExpression<T> {
    private final Class<? extends T> c;
    private final Changer<? super T, ?> changer;
    private final Map<Class<? extends Event>, Getter<? extends T, ?>> getters = new HashMap();
    private final Validator<T> validator;

    public EventValueExpression(Class<? extends T> c) {
        this(c, Skript.getSuperClassInfo(c).getChanger());
    }

    public EventValueExpression(Class<? extends T> c, Changer<? super T, ?> changer) {
        Validate.notNull(c, "c");
        this.c = c;
        ClassInfo<T> ci = Skript.getSuperClassInfo(c);
        this.validator = ci == null ? null : ci.getValidator();
        this.changer = changer;
    }

    @Override
    protected T[] get(Event e) {
        T o = this.getValue(e);
        if (o == null) {
            return null;
        }
        Object[] one = (Object[])Array.newInstance(this.c, 1);
        one[0] = o;
        return one;
    }

    private <E extends Event> T getValue(E e) {
        Getter<T, ?> g = this.getters.get(e.getClass());
        if (g != null) {
            return this.validator != null ? this.validator.validate(g.get(e)) : g.get(e);
        }
        for (Map.Entry<Class<Event>, Getter<T, ?>> p : this.getters.entrySet()) {
            if (!p.getKey().isAssignableFrom(e.getClass())) continue;
            this.getters.put(e.getClass(), p.getValue());
            return this.validator != null ? this.validator.validate(p.getValue().get(e)) : p.getValue().get(e);
        }
        return null;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parser) {
        if (exprs.length != 0) {
            throw new SkriptAPIException(String.valueOf(this.getClass().getName()) + " has expressions in it's pattern but does not override init(...)");
        }
        return this.init();
    }

    @Override
    public boolean init() {
        boolean hasValue = false;
        SubLog log = SkriptLogger.startSubLog();
        Class<? extends Event>[] classArray = ScriptLoader.currentEvents;
        int n = ScriptLoader.currentEvents.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Event> e = classArray[n2];
            if (this.getters.containsKey(e)) {
                hasValue = true;
            } else {
                Getter<? extends T, ? extends Event> getter = Skript.getEventValueGetter(e, this.c, this.getTime());
                if (getter != null) {
                    this.getters.put(e, getter);
                    hasValue = true;
                }
            }
            ++n2;
        }
        log.stop();
        if (!hasValue) {
            log.printErrors("There's no " + Skript.getSuperClassInfo(this.c).getName() + " in this event");
            return false;
        }
        log.printLog();
        return true;
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.c;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (!debug || e == null) {
            return "event-" + Skript.getSuperClassInfo(this.c).getName();
        }
        return Skript.getDebugMessage(this.getValue(e));
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        if (this.changer == null) {
            return null;
        }
        return this.changer.acceptChange(mode);
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        if (this.changer == null) {
            throw new UnsupportedOperationException();
        }
        Changer.ChangerUtils.change(this.changer, this.getArray(e), delta, mode);
    }

    @Override
    public boolean setTime(int time) {
        Class<? extends Event>[] classArray = ScriptLoader.currentEvents;
        int n = ScriptLoader.currentEvents.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Event> e = classArray[n2];
            if (Skript.doesEventValueHaveTimeStates(e, this.c)) {
                super.setTime(time);
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

