/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Utils;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerQuitEvent;

public class ExprQuitMessage
extends SimpleExpression<String> {
    static {
        Skript.registerExpression(ExprQuitMessage.class, String.class, Skript.ExpressionType.SIMPLE, "[the] (quit|leave|log[ ]out)( |-)message");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Utils.contains(ScriptLoader.currentEvents, PlayerQuitEvent.class)) {
            Skript.error("The quit message can only be used in a quit event");
            return false;
        }
        return true;
    }

    protected String[] get(Event e) {
        return new String[]{((PlayerQuitEvent)e).getQuitMessage()};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public boolean getAnd() {
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the message";
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return String.class;
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        ((PlayerQuitEvent)e).setQuitMessage(Utils.replaceChatStyles((String)delta));
    }
}

