/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Loop;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import java.lang.reflect.Array;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.event.Event;

public class ExprLoopValue
extends SimpleExpression<Object> {
    private String name;
    private Loop loop;

    static {
        Skript.registerExpression(ExprLoopValue.class, Object.class, Skript.ExpressionType.SIMPLE, "[the] loop-<.+>");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, int isDelayed, SkriptParser.ParseResult parser) {
        Class<?> c;
        this.name = parser.expr;
        String s = parser.regexes.get(0).group();
        int i = -1;
        Matcher m = Pattern.compile("^(.+)-(\\d+)$").matcher(s);
        if (m.matches()) {
            s = m.group(1);
            i = Skript.parseInt(m.group(2));
        }
        if ((c = Skript.getClassByName(s)) == null) {
            c = Skript.getClassFromUserInput(s);
        }
        for (Loop l : ScriptLoader.currentLoops) {
            if ((c == null || !c.isAssignableFrom(l.getLoopedExpression().getReturnType())) && !l.getLoopedExpression().isLoopOf(s)) continue;
            if (i > 1) {
                --i;
                continue;
            }
            if (this.loop != null) {
                Skript.error("there are multiple loops that match 'loop-" + s + "'");
                return false;
            }
            this.loop = l;
            if (i == 1) break;
        }
        if (this.loop == null) {
            Skript.error("there's no loop that matches 'loop-" + s + "'");
            return false;
        }
        return true;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return this.loop.getLoopedExpression().getReturnType();
    }

    @Override
    protected Object[] get(Event e) {
        Object[] one = (Object[])Array.newInstance(this.loop.getLoopedExpression().getReturnType(), 1);
        one[0] = this.loop.getCurrent(e);
        return one;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e == null) {
            return this.name;
        }
        return Skript.getDebugMessage(this.loop.getCurrent(e));
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

