/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.effects.EffSpawn;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.log.SubLog;
import ch.njol.skript.util.Utils;
import java.lang.reflect.Array;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

public class ExprLastSpawnedEntity
extends SimpleExpression<Entity> {
    private EntityData<?> type;

    static {
        Skript.registerExpression(ExprLastSpawnedEntity.class, Entity.class, Skript.ExpressionType.SIMPLE, "[last[ly]] spawned <.+>");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        SubLog log = SkriptLogger.startSubLog();
        this.type = EntityData.parseWithoutAnOrAny(parseResult.regexes.get(0).group());
        log.stop();
        if (this.type == null) {
            return false;
        }
        log.printLog();
        return true;
    }

    protected Entity[] get(Event e) {
        Entity en = Utils.validate(EffSpawn.lastSpawned);
        if (en == null) {
            return null;
        }
        if (!this.type.isInstance(en)) {
            return null;
        }
        Entity[] one = (Entity[])Array.newInstance(this.type.getType(), 1);
        one[0] = en;
        return one;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return this.type.getType();
    }

    @Override
    public boolean getAnd() {
        return false;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "last spawned " + this.type;
    }
}

