/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Utils;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class ExprDamage
extends SimpleExpression<Float> {
    static {
        Skript.registerExpression(ExprDamage.class, Float.class, Skript.ExpressionType.SIMPLE, "[the] damage");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Utils.containsAny(ScriptLoader.currentEvents, EntityDamageEvent.class, EntityDamageByBlockEvent.class, EntityDamageByEntityEvent.class)) {
            Skript.error("'damage' can only be used in damage events");
            return false;
        }
        return true;
    }

    protected Float[] get(Event e) {
        if (!(e instanceof EntityDamageEvent)) {
            return null;
        }
        return new Float[]{Float.valueOf(0.5f * (float)((EntityDamageEvent)e).getDamage())};
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return Float.class;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        if (!(e instanceof EntityDamageEvent)) {
            return;
        }
        int d = mode == Changer.ChangeMode.CLEAR ? 0 : Math.round(2.0f * ((Float)delta).floatValue());
        switch (mode) {
            case SET: {
                ((EntityDamageEvent)e).setDamage(d);
                break;
            }
            case ADD: {
                ((EntityDamageEvent)e).setDamage(((EntityDamageEvent)e).getDamage() + d);
                break;
            }
            case REMOVE: {
                ((EntityDamageEvent)e).setDamage(((EntityDamageEvent)e).getDamage() - d);
                break;
            }
            case CLEAR: {
                ((EntityDamageEvent)e).setDamage(0);
            }
        }
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Float> getReturnType() {
        return Float.class;
    }

    @Override
    public boolean getAnd() {
        return false;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the damage";
    }
}

