/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.ItemType;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ExprColorOf
extends PropertyExpression<ItemStack, Color> {
    private Expression<ItemStack> types;

    static {
        Skript.registerExpression(ExprColorOf.class, Color.class, Skript.ExpressionType.PROPERTY, "colo[u]r[s] of %itemstacks%", "%itemstacks%'[s] colo[u]r[s]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        this.types = exprs[0];
        this.setExpr(this.types);
        return true;
    }

    @Override
    public Class<Color> getReturnType() {
        return Color.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "color of " + this.types.toString(e, debug);
    }

    protected Color[] get(Event e, ItemStack[] source) {
        return this.get(source, new Converter<ItemStack, Color>(){

            @Override
            public Color convert(ItemStack is) {
                if (is == null) {
                    return null;
                }
                if (is.getType() == Material.WOOL) {
                    return Color.byWool(is.getDurability());
                }
                if (is.getType() == Material.INK_SACK) {
                    return Color.byDye(is.getDurability());
                }
                return null;
            }
        });
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.SET || !this.types.isSingle()) {
            return null;
        }
        if (this.types.acceptChange(mode) == ItemStack.class || this.types.acceptChange(mode) == ItemType.class) {
            return Color.class;
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        ItemStack is = this.types.getSingle(e);
        if (is == null) {
            return;
        }
        if (is.getType() == Material.WOOL) {
            is.setDurability((short)((Color)((Object)delta)).getWool());
        } else if (is.getType() == Material.INK_SACK) {
            is.setDurability((short)((Color)((Object)delta)).getDye());
        } else {
            return;
        }
        if (this.types.acceptChange(mode) == ItemStack.class) {
            this.types.change(e, is, mode);
        } else {
            this.types.change(e, new ItemType(is), mode);
        }
    }
}

