/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.data.DefaultChangers;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Offset;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

public class ExprBlock
extends SimpleExpression<Block> {
    private Expression<Offset> offset = null;
    private Expression<Block> block;

    static {
        Skript.registerExpression(ExprBlock.class, Block.class, Skript.ExpressionType.SIMPLE, "[the] [event-]block");
        Skript.registerExpression(ExprBlock.class, Block.class, Skript.ExpressionType.NORMAL, "[the] block %offset% [%block%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parser) {
        if (exprs.length > 0) {
            this.offset = exprs[0];
            this.block = exprs[1];
            return true;
        }
        this.block = new EventValueExpression<Block>(Block.class);
        return ((EventValueExpression)this.block).init();
    }

    protected Block[] get(Event e) {
        if (this.offset == null) {
            return this.block.getArray(e);
        }
        Offset o = this.offset.getSingle(e);
        if (o == null) {
            return null;
        }
        return new Block[]{o.getRelative(this.block.getSingle(e))};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return this.offset == null ? "the block" : "the block " + this.offset.toString(e, debug) + " " + this.block.toString(e, debug);
    }

    @Override
    public boolean isDefault() {
        return this.offset == null;
    }

    @Override
    public boolean setTime(int time) {
        if (this.offset != null) {
            return false;
        }
        return this.block.setTime(time);
    }

    @Override
    public int getTime() {
        return this.block.getTime();
    }

    @Override
    public boolean getAnd() {
        return this.block.getAnd();
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return DefaultChangers.blockChanger.acceptChange(mode);
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        DefaultChangers.blockChanger.change((Block[])((Block[])this.getArray(e)), delta, mode);
    }
}

