/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;

public class EvtChat
extends SkriptEvent {
    private static final Collection<Trigger> triggers;
    private static boolean registeredExecutor;
    private static final EventExecutor executor;

    static {
        Skript.registerEvent(EvtChat.class, AsyncPlayerChatEvent.class, false, "chat");
        triggers = new ArrayList<Trigger>();
        registeredExecutor = false;
        executor = new EventExecutor(){

            private final void execute(Event e) {
                SkriptEventHandler.logEventStart(e);
                for (Trigger t : triggers) {
                    SkriptEventHandler.logTriggerStart(t);
                    t.start(e);
                    SkriptEventHandler.logTriggerEnd(t);
                }
                SkriptEventHandler.logEventEnd();
            }

            public void execute(Listener l, final Event e) throws EventException {
                if (!triggers.isEmpty()) {
                    if (!e.isAsynchronous()) {
                        this.execute(e);
                        return;
                    }
                    Future f = Bukkit.getScheduler().callSyncMethod((Plugin)Skript.getInstance(), (Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            this.execute(e);
                            return null;
                        }
                    });
                    try {
                        while (true) {
                            try {
                                f.get();
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (ExecutionException e1) {
                        Skript.exception(e1, new String[0]);
                    }
                }
            }
        };
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        return true;
    }

    @Override
    public boolean check(Event e) {
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "chat";
    }

    @Override
    public void register(Trigger t) {
        triggers.add(t);
        if (!registeredExecutor) {
            Bukkit.getPluginManager().registerEvent(AsyncPlayerChatEvent.class, new Listener(){}, Skript.getDefaultEventPriority(), executor, (Plugin)Skript.getInstance(), true);
            registeredExecutor = true;
        }
    }

    @Override
    public void unregister(Trigger t) {
        triggers.remove(t);
    }

    @Override
    public void unregisterAll() {
        triggers.clear();
    }
}

